// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of the regional restorable account.
 */
@Immutable
public final class RestorableLocationResource implements JsonSerializable<RestorableLocationResource> {
    /*
     * The location of the regional restorable account.
     */
    private String locationName;

    /*
     * The instance id of the regional restorable account.
     */
    private String regionalDatabaseAccountInstanceId;

    /*
     * The creation time of the regional restorable database account (ISO-8601 format).
     */
    private OffsetDateTime creationTime;

    /*
     * The time at which the regional restorable database account has been deleted (ISO-8601 format).
     */
    private OffsetDateTime deletionTime;

    /**
     * Creates an instance of RestorableLocationResource class.
     */
    public RestorableLocationResource() {
    }

    /**
     * Get the locationName property: The location of the regional restorable account.
     * 
     * @return the locationName value.
     */
    public String locationName() {
        return this.locationName;
    }

    /**
     * Get the regionalDatabaseAccountInstanceId property: The instance id of the regional restorable account.
     * 
     * @return the regionalDatabaseAccountInstanceId value.
     */
    public String regionalDatabaseAccountInstanceId() {
        return this.regionalDatabaseAccountInstanceId;
    }

    /**
     * Get the creationTime property: The creation time of the regional restorable database account (ISO-8601 format).
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the deletionTime property: The time at which the regional restorable database account has been deleted
     * (ISO-8601 format).
     * 
     * @return the deletionTime value.
     */
    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableLocationResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableLocationResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableLocationResource.
     */
    public static RestorableLocationResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableLocationResource deserializedRestorableLocationResource = new RestorableLocationResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locationName".equals(fieldName)) {
                    deserializedRestorableLocationResource.locationName = reader.getString();
                } else if ("regionalDatabaseAccountInstanceId".equals(fieldName)) {
                    deserializedRestorableLocationResource.regionalDatabaseAccountInstanceId = reader.getString();
                } else if ("creationTime".equals(fieldName)) {
                    deserializedRestorableLocationResource.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("deletionTime".equals(fieldName)) {
                    deserializedRestorableLocationResource.deletionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableLocationResource;
        });
    }
}
