// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.MinimalTlsVersion;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

/**
 * Properties to create and update Azure Cosmos DB database accounts.
 */
@Fluent
public final class DatabaseAccountCreateUpdateProperties
    implements JsonSerializable<DatabaseAccountCreateUpdateProperties> {
    /*
     * The consistency policy for the Cosmos DB account.
     */
    private ConsistencyPolicy consistencyPolicy;

    /*
     * An array that contains the georeplication locations enabled for the Cosmos DB account.
     */
    private List<Location> locations;

    /*
     * The offer type for the database
     */
    private final String databaseAccountOfferType = "Standard";

    /*
     * List of IpRules.
     */
    private List<IpAddressOrRange> ipRules;

    /*
     * Flag to indicate whether to enable/disable Virtual Network ACL rules.
     */
    private Boolean isVirtualNetworkFilterEnabled;

    /*
     * Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage.
     * Automatic failover will result in a new write region for the account and is chosen based on the failover
     * priorities configured for the account.
     */
    private Boolean enableAutomaticFailover;

    /*
     * List of Cosmos DB capabilities for the account
     */
    private List<Capability> capabilities;

    /*
     * List of Virtual Network ACL rules configured for the Cosmos DB account.
     */
    private List<VirtualNetworkRule> virtualNetworkRules;

    /*
     * Enables the account to write in multiple locations
     */
    private Boolean enableMultipleWriteLocations;

    /*
     * Enables the cassandra connector on the Cosmos DB C* account
     */
    private Boolean enableCassandraConnector;

    /*
     * The cassandra connector offer type for the Cosmos DB database C* account.
     */
    private ConnectorOffer connectorOffer;

    /*
     * Disable write operations on metadata resources (databases, containers, throughput) via account keys
     */
    private Boolean disableKeyBasedMetadataWriteAccess;

    /*
     * The URI of the key vault
     */
    private String keyVaultKeyUri;

    /*
     * The default identity for accessing key vault used in features like customer managed keys. The default identity
     * needs to be explicitly set by the users. It can be "FirstPartyIdentity", "SystemAssignedIdentity" and more.
     */
    private String defaultIdentity;

    /*
     * Whether requests from Public Network are allowed
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Flag to indicate whether Free Tier is enabled.
     */
    private Boolean enableFreeTier;

    /*
     * API specific properties. Currently, supported only for MongoDB API.
     */
    private ApiProperties apiProperties;

    /*
     * Flag to indicate whether to enable storage analytics.
     */
    private Boolean enableAnalyticalStorage;

    /*
     * Analytical storage specific properties.
     */
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;

    /*
     * Enum to indicate the mode of account creation.
     */
    private CreateMode createMode;

    /*
     * The object representing the policy for taking backups on an account.
     */
    private BackupPolicy backupPolicy;

    /*
     * The CORS policy for the Cosmos DB database account.
     */
    private List<CorsPolicy> cors;

    /*
     * Indicates what services are allowed to bypass firewall checks.
     */
    private NetworkAclBypass networkAclBypass;

    /*
     * An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
     */
    private List<String> networkAclBypassResourceIds;

    /*
     * Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
     */
    private Boolean disableLocalAuth;

    /*
     * Parameters to indicate the information about the restore.
     */
    private RestoreParameters restoreParameters;

    /*
     * The object that represents all properties related to capacity enforcement on an account.
     */
    private Capacity capacity;

    /*
     * This property is ignored during the update/create operation, as the metadata is read-only. The object represents
     * the metadata for the Account Keys of the Cosmos DB account.
     */
    private DatabaseAccountKeysMetadata keysMetadata;

    /*
     * Flag to indicate enabling/disabling of Partition Merge feature on the account
     */
    private Boolean enablePartitionMerge;

    /*
     * Indicates the minimum allowed Tls version. The default value is Tls 1.2. Cassandra and Mongo APIs only work with
     * Tls 1.2.
     */
    private MinimalTlsVersion minimalTlsVersion;

    /*
     * Flag to indicate enabling/disabling of Burst Capacity feature on the account
     */
    private Boolean enableBurstCapacity;

    /*
     * Indicates the status of the Customer Managed Key feature on the account. In case there are errors, the property
     * provides troubleshooting guidance.
     */
    private String customerManagedKeyStatus;

    /*
     * Flag to indicate enabling/disabling of PerRegionPerPartitionAutoscale feature on the account
     */
    private Boolean enablePerRegionPerPartitionAutoscale;

    /**
     * Creates an instance of DatabaseAccountCreateUpdateProperties class.
     */
    public DatabaseAccountCreateUpdateProperties() {
    }

    /**
     * Get the consistencyPolicy property: The consistency policy for the Cosmos DB account.
     * 
     * @return the consistencyPolicy value.
     */
    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    /**
     * Set the consistencyPolicy property: The consistency policy for the Cosmos DB account.
     * 
     * @param consistencyPolicy the consistencyPolicy value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    /**
     * Get the locations property: An array that contains the georeplication locations enabled for the Cosmos DB
     * account.
     * 
     * @return the locations value.
     */
    public List<Location> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: An array that contains the georeplication locations enabled for the Cosmos DB
     * account.
     * 
     * @param locations the locations value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the databaseAccountOfferType property: The offer type for the database.
     * 
     * @return the databaseAccountOfferType value.
     */
    public String databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    /**
     * Get the ipRules property: List of IpRules.
     * 
     * @return the ipRules value.
     */
    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    /**
     * Set the ipRules property: List of IpRules.
     * 
     * @param ipRules the ipRules value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    /**
     * Get the isVirtualNetworkFilterEnabled property: Flag to indicate whether to enable/disable Virtual Network ACL
     * rules.
     * 
     * @return the isVirtualNetworkFilterEnabled value.
     */
    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    /**
     * Set the isVirtualNetworkFilterEnabled property: Flag to indicate whether to enable/disable Virtual Network ACL
     * rules.
     * 
     * @param isVirtualNetworkFilterEnabled the isVirtualNetworkFilterEnabled value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    /**
     * Get the enableAutomaticFailover property: Enables automatic failover of the write region in the rare event that
     * the region is unavailable due to an outage. Automatic failover will result in a new write region for the account
     * and is chosen based on the failover priorities configured for the account.
     * 
     * @return the enableAutomaticFailover value.
     */
    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    /**
     * Set the enableAutomaticFailover property: Enables automatic failover of the write region in the rare event that
     * the region is unavailable due to an outage. Automatic failover will result in a new write region for the account
     * and is chosen based on the failover priorities configured for the account.
     * 
     * @param enableAutomaticFailover the enableAutomaticFailover value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    /**
     * Get the capabilities property: List of Cosmos DB capabilities for the account.
     * 
     * @return the capabilities value.
     */
    public List<Capability> capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: List of Cosmos DB capabilities for the account.
     * 
     * @param capabilities the capabilities value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the virtualNetworkRules property: List of Virtual Network ACL rules configured for the Cosmos DB account.
     * 
     * @return the virtualNetworkRules value.
     */
    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    /**
     * Set the virtualNetworkRules property: List of Virtual Network ACL rules configured for the Cosmos DB account.
     * 
     * @param virtualNetworkRules the virtualNetworkRules value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    /**
     * Get the enableMultipleWriteLocations property: Enables the account to write in multiple locations.
     * 
     * @return the enableMultipleWriteLocations value.
     */
    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    /**
     * Set the enableMultipleWriteLocations property: Enables the account to write in multiple locations.
     * 
     * @param enableMultipleWriteLocations the enableMultipleWriteLocations value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    /**
     * Get the enableCassandraConnector property: Enables the cassandra connector on the Cosmos DB C* account.
     * 
     * @return the enableCassandraConnector value.
     */
    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    /**
     * Set the enableCassandraConnector property: Enables the cassandra connector on the Cosmos DB C* account.
     * 
     * @param enableCassandraConnector the enableCassandraConnector value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    /**
     * Get the connectorOffer property: The cassandra connector offer type for the Cosmos DB database C* account.
     * 
     * @return the connectorOffer value.
     */
    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    /**
     * Set the connectorOffer property: The cassandra connector offer type for the Cosmos DB database C* account.
     * 
     * @param connectorOffer the connectorOffer value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    /**
     * Get the disableKeyBasedMetadataWriteAccess property: Disable write operations on metadata resources (databases,
     * containers, throughput) via account keys.
     * 
     * @return the disableKeyBasedMetadataWriteAccess value.
     */
    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    /**
     * Set the disableKeyBasedMetadataWriteAccess property: Disable write operations on metadata resources (databases,
     * containers, throughput) via account keys.
     * 
     * @param disableKeyBasedMetadataWriteAccess the disableKeyBasedMetadataWriteAccess value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    /**
     * Get the keyVaultKeyUri property: The URI of the key vault.
     * 
     * @return the keyVaultKeyUri value.
     */
    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    /**
     * Set the keyVaultKeyUri property: The URI of the key vault.
     * 
     * @param keyVaultKeyUri the keyVaultKeyUri value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    /**
     * Get the defaultIdentity property: The default identity for accessing key vault used in features like customer
     * managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity",
     * "SystemAssignedIdentity" and more.
     * 
     * @return the defaultIdentity value.
     */
    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    /**
     * Set the defaultIdentity property: The default identity for accessing key vault used in features like customer
     * managed keys. The default identity needs to be explicitly set by the users. It can be "FirstPartyIdentity",
     * "SystemAssignedIdentity" and more.
     * 
     * @param defaultIdentity the defaultIdentity value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether requests from Public Network are allowed.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether requests from Public Network are allowed.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the enableFreeTier property: Flag to indicate whether Free Tier is enabled.
     * 
     * @return the enableFreeTier value.
     */
    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    /**
     * Set the enableFreeTier property: Flag to indicate whether Free Tier is enabled.
     * 
     * @param enableFreeTier the enableFreeTier value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    /**
     * Get the apiProperties property: API specific properties. Currently, supported only for MongoDB API.
     * 
     * @return the apiProperties value.
     */
    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    /**
     * Set the apiProperties property: API specific properties. Currently, supported only for MongoDB API.
     * 
     * @param apiProperties the apiProperties value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    /**
     * Get the enableAnalyticalStorage property: Flag to indicate whether to enable storage analytics.
     * 
     * @return the enableAnalyticalStorage value.
     */
    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    /**
     * Set the enableAnalyticalStorage property: Flag to indicate whether to enable storage analytics.
     * 
     * @param enableAnalyticalStorage the enableAnalyticalStorage value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    /**
     * Get the analyticalStorageConfiguration property: Analytical storage specific properties.
     * 
     * @return the analyticalStorageConfiguration value.
     */
    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    /**
     * Set the analyticalStorageConfiguration property: Analytical storage specific properties.
     * 
     * @param analyticalStorageConfiguration the analyticalStorageConfiguration value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    /**
     * Get the createMode property: Enum to indicate the mode of account creation.
     * 
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode property: Enum to indicate the mode of account creation.
     * 
     * @param createMode the createMode value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the backupPolicy property: The object representing the policy for taking backups on an account.
     * 
     * @return the backupPolicy value.
     */
    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    /**
     * Set the backupPolicy property: The object representing the policy for taking backups on an account.
     * 
     * @param backupPolicy the backupPolicy value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    /**
     * Get the cors property: The CORS policy for the Cosmos DB database account.
     * 
     * @return the cors value.
     */
    public List<CorsPolicy> cors() {
        return this.cors;
    }

    /**
     * Set the cors property: The CORS policy for the Cosmos DB database account.
     * 
     * @param cors the cors value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    /**
     * Get the networkAclBypass property: Indicates what services are allowed to bypass firewall checks.
     * 
     * @return the networkAclBypass value.
     */
    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    /**
     * Set the networkAclBypass property: Indicates what services are allowed to bypass firewall checks.
     * 
     * @param networkAclBypass the networkAclBypass value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    /**
     * Get the networkAclBypassResourceIds property: An array that contains the Resource Ids for Network Acl Bypass for
     * the Cosmos DB account.
     * 
     * @return the networkAclBypassResourceIds value.
     */
    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    /**
     * Set the networkAclBypassResourceIds property: An array that contains the Resource Ids for Network Acl Bypass for
     * the Cosmos DB account.
     * 
     * @param networkAclBypassResourceIds the networkAclBypassResourceIds value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    /**
     * Get the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     * 
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    /**
     * Set the disableLocalAuth property: Opt-out of local authentication and ensure only MSI and AAD can be used
     * exclusively for authentication.
     * 
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    /**
     * Get the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @return the restoreParameters value.
     */
    public RestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    /**
     * Set the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @param restoreParameters the restoreParameters value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withRestoreParameters(RestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    /**
     * Get the capacity property: The object that represents all properties related to capacity enforcement on an
     * account.
     * 
     * @return the capacity value.
     */
    public Capacity capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: The object that represents all properties related to capacity enforcement on an
     * account.
     * 
     * @param capacity the capacity value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Get the keysMetadata property: This property is ignored during the update/create operation, as the metadata is
     * read-only. The object represents the metadata for the Account Keys of the Cosmos DB account.
     * 
     * @return the keysMetadata value.
     */
    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.keysMetadata;
    }

    /**
     * Get the enablePartitionMerge property: Flag to indicate enabling/disabling of Partition Merge feature on the
     * account.
     * 
     * @return the enablePartitionMerge value.
     */
    public Boolean enablePartitionMerge() {
        return this.enablePartitionMerge;
    }

    /**
     * Set the enablePartitionMerge property: Flag to indicate enabling/disabling of Partition Merge feature on the
     * account.
     * 
     * @param enablePartitionMerge the enablePartitionMerge value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnablePartitionMerge(Boolean enablePartitionMerge) {
        this.enablePartitionMerge = enablePartitionMerge;
        return this;
    }

    /**
     * Get the minimalTlsVersion property: Indicates the minimum allowed Tls version. The default value is Tls 1.2.
     * Cassandra and Mongo APIs only work with Tls 1.2.
     * 
     * @return the minimalTlsVersion value.
     */
    public MinimalTlsVersion minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    /**
     * Set the minimalTlsVersion property: Indicates the minimum allowed Tls version. The default value is Tls 1.2.
     * Cassandra and Mongo APIs only work with Tls 1.2.
     * 
     * @param minimalTlsVersion the minimalTlsVersion value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    /**
     * Get the enableBurstCapacity property: Flag to indicate enabling/disabling of Burst Capacity feature on the
     * account.
     * 
     * @return the enableBurstCapacity value.
     */
    public Boolean enableBurstCapacity() {
        return this.enableBurstCapacity;
    }

    /**
     * Set the enableBurstCapacity property: Flag to indicate enabling/disabling of Burst Capacity feature on the
     * account.
     * 
     * @param enableBurstCapacity the enableBurstCapacity value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withEnableBurstCapacity(Boolean enableBurstCapacity) {
        this.enableBurstCapacity = enableBurstCapacity;
        return this;
    }

    /**
     * Get the customerManagedKeyStatus property: Indicates the status of the Customer Managed Key feature on the
     * account. In case there are errors, the property provides troubleshooting guidance.
     * 
     * @return the customerManagedKeyStatus value.
     */
    public String customerManagedKeyStatus() {
        return this.customerManagedKeyStatus;
    }

    /**
     * Set the customerManagedKeyStatus property: Indicates the status of the Customer Managed Key feature on the
     * account. In case there are errors, the property provides troubleshooting guidance.
     * 
     * @param customerManagedKeyStatus the customerManagedKeyStatus value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        this.customerManagedKeyStatus = customerManagedKeyStatus;
        return this;
    }

    /**
     * Get the enablePerRegionPerPartitionAutoscale property: Flag to indicate enabling/disabling of
     * PerRegionPerPartitionAutoscale feature on the account.
     * 
     * @return the enablePerRegionPerPartitionAutoscale value.
     */
    public Boolean enablePerRegionPerPartitionAutoscale() {
        return this.enablePerRegionPerPartitionAutoscale;
    }

    /**
     * Set the enablePerRegionPerPartitionAutoscale property: Flag to indicate enabling/disabling of
     * PerRegionPerPartitionAutoscale feature on the account.
     * 
     * @param enablePerRegionPerPartitionAutoscale the enablePerRegionPerPartitionAutoscale value to set.
     * @return the DatabaseAccountCreateUpdateProperties object itself.
     */
    public DatabaseAccountCreateUpdateProperties
        withEnablePerRegionPerPartitionAutoscale(Boolean enablePerRegionPerPartitionAutoscale) {
        this.enablePerRegionPerPartitionAutoscale = enablePerRegionPerPartitionAutoscale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (consistencyPolicy() != null) {
            consistencyPolicy().validate();
        }
        if (locations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property locations in model DatabaseAccountCreateUpdateProperties"));
        } else {
            locations().forEach(e -> e.validate());
        }
        if (ipRules() != null) {
            ipRules().forEach(e -> e.validate());
        }
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
        if (virtualNetworkRules() != null) {
            virtualNetworkRules().forEach(e -> e.validate());
        }
        if (apiProperties() != null) {
            apiProperties().validate();
        }
        if (analyticalStorageConfiguration() != null) {
            analyticalStorageConfiguration().validate();
        }
        if (backupPolicy() != null) {
            backupPolicy().validate();
        }
        if (cors() != null) {
            cors().forEach(e -> e.validate());
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
        if (capacity() != null) {
            capacity().validate();
        }
        if (keysMetadata() != null) {
            keysMetadata().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountCreateUpdateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("databaseAccountOfferType", this.databaseAccountOfferType);
        jsonWriter.writeJsonField("consistencyPolicy", this.consistencyPolicy);
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("isVirtualNetworkFilterEnabled", this.isVirtualNetworkFilterEnabled);
        jsonWriter.writeBooleanField("enableAutomaticFailover", this.enableAutomaticFailover);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("enableMultipleWriteLocations", this.enableMultipleWriteLocations);
        jsonWriter.writeBooleanField("enableCassandraConnector", this.enableCassandraConnector);
        jsonWriter.writeStringField("connectorOffer",
            this.connectorOffer == null ? null : this.connectorOffer.toString());
        jsonWriter.writeBooleanField("disableKeyBasedMetadataWriteAccess", this.disableKeyBasedMetadataWriteAccess);
        jsonWriter.writeStringField("keyVaultKeyUri", this.keyVaultKeyUri);
        jsonWriter.writeStringField("defaultIdentity", this.defaultIdentity);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("enableFreeTier", this.enableFreeTier);
        jsonWriter.writeJsonField("apiProperties", this.apiProperties);
        jsonWriter.writeBooleanField("enableAnalyticalStorage", this.enableAnalyticalStorage);
        jsonWriter.writeJsonField("analyticalStorageConfiguration", this.analyticalStorageConfiguration);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeJsonField("backupPolicy", this.backupPolicy);
        jsonWriter.writeArrayField("cors", this.cors, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("networkAclBypass",
            this.networkAclBypass == null ? null : this.networkAclBypass.toString());
        jsonWriter.writeArrayField("networkAclBypassResourceIds", this.networkAclBypassResourceIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters);
        jsonWriter.writeJsonField("capacity", this.capacity);
        jsonWriter.writeBooleanField("enablePartitionMerge", this.enablePartitionMerge);
        jsonWriter.writeStringField("minimalTlsVersion",
            this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeBooleanField("enableBurstCapacity", this.enableBurstCapacity);
        jsonWriter.writeStringField("customerManagedKeyStatus", this.customerManagedKeyStatus);
        jsonWriter.writeBooleanField("enablePerRegionPerPartitionAutoscale", this.enablePerRegionPerPartitionAutoscale);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseAccountCreateUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseAccountCreateUpdateProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseAccountCreateUpdateProperties.
     */
    public static DatabaseAccountCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseAccountCreateUpdateProperties deserializedDatabaseAccountCreateUpdateProperties
                = new DatabaseAccountCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locations".equals(fieldName)) {
                    List<Location> locations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    deserializedDatabaseAccountCreateUpdateProperties.locations = locations;
                } else if ("consistencyPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.consistencyPolicy
                        = ConsistencyPolicy.fromJson(reader);
                } else if ("ipRules".equals(fieldName)) {
                    List<IpAddressOrRange> ipRules = reader.readArray(reader1 -> IpAddressOrRange.fromJson(reader1));
                    deserializedDatabaseAccountCreateUpdateProperties.ipRules = ipRules;
                } else if ("isVirtualNetworkFilterEnabled".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.isVirtualNetworkFilterEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableAutomaticFailover".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableAutomaticFailover
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("capabilities".equals(fieldName)) {
                    List<Capability> capabilities = reader.readArray(reader1 -> Capability.fromJson(reader1));
                    deserializedDatabaseAccountCreateUpdateProperties.capabilities = capabilities;
                } else if ("virtualNetworkRules".equals(fieldName)) {
                    List<VirtualNetworkRule> virtualNetworkRules
                        = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    deserializedDatabaseAccountCreateUpdateProperties.virtualNetworkRules = virtualNetworkRules;
                } else if ("enableMultipleWriteLocations".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableMultipleWriteLocations
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableCassandraConnector".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableCassandraConnector
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("connectorOffer".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.connectorOffer
                        = ConnectorOffer.fromString(reader.getString());
                } else if ("disableKeyBasedMetadataWriteAccess".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.disableKeyBasedMetadataWriteAccess
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("keyVaultKeyUri".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.keyVaultKeyUri = reader.getString();
                } else if ("defaultIdentity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.defaultIdentity = reader.getString();
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("enableFreeTier".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableFreeTier
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("apiProperties".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.apiProperties = ApiProperties.fromJson(reader);
                } else if ("enableAnalyticalStorage".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableAnalyticalStorage
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("analyticalStorageConfiguration".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.analyticalStorageConfiguration
                        = AnalyticalStorageConfiguration.fromJson(reader);
                } else if ("createMode".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.createMode
                        = CreateMode.fromString(reader.getString());
                } else if ("backupPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.backupPolicy = BackupPolicy.fromJson(reader);
                } else if ("cors".equals(fieldName)) {
                    List<CorsPolicy> cors = reader.readArray(reader1 -> CorsPolicy.fromJson(reader1));
                    deserializedDatabaseAccountCreateUpdateProperties.cors = cors;
                } else if ("networkAclBypass".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.networkAclBypass
                        = NetworkAclBypass.fromString(reader.getString());
                } else if ("networkAclBypassResourceIds".equals(fieldName)) {
                    List<String> networkAclBypassResourceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedDatabaseAccountCreateUpdateProperties.networkAclBypassResourceIds
                        = networkAclBypassResourceIds;
                } else if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.disableLocalAuth
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.restoreParameters
                        = RestoreParameters.fromJson(reader);
                } else if ("capacity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.capacity = Capacity.fromJson(reader);
                } else if ("keysMetadata".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.keysMetadata
                        = DatabaseAccountKeysMetadata.fromJson(reader);
                } else if ("enablePartitionMerge".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enablePartitionMerge
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.minimalTlsVersion
                        = MinimalTlsVersion.fromString(reader.getString());
                } else if ("enableBurstCapacity".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enableBurstCapacity
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("customerManagedKeyStatus".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.customerManagedKeyStatus = reader.getString();
                } else if ("enablePerRegionPerPartitionAutoscale".equals(fieldName)) {
                    deserializedDatabaseAccountCreateUpdateProperties.enablePerRegionPerPartitionAutoscale
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseAccountCreateUpdateProperties;
        });
    }
}
