// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AutoscaleSettings model.
 */
@Fluent
public final class AutoscaleSettings implements JsonSerializable<AutoscaleSettings> {
    /*
     * Represents maximum throughput, the resource can scale up to.
     */
    private Integer maxThroughput;

    /**
     * Creates an instance of AutoscaleSettings class.
     */
    public AutoscaleSettings() {
    }

    /**
     * Get the maxThroughput property: Represents maximum throughput, the resource can scale up to.
     * 
     * @return the maxThroughput value.
     */
    public Integer maxThroughput() {
        return this.maxThroughput;
    }

    /**
     * Set the maxThroughput property: Represents maximum throughput, the resource can scale up to.
     * 
     * @param maxThroughput the maxThroughput value to set.
     * @return the AutoscaleSettings object itself.
     */
    public AutoscaleSettings withMaxThroughput(Integer maxThroughput) {
        this.maxThroughput = maxThroughput;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxThroughput", this.maxThroughput);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoscaleSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoscaleSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoscaleSettings.
     */
    public static AutoscaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoscaleSettings deserializedAutoscaleSettings = new AutoscaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxThroughput".equals(fieldName)) {
                    deserializedAutoscaleSettings.maxThroughput = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoscaleSettings;
        });
    }
}
