// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB Cassandra table column.
 */
@Fluent
public final class Column implements JsonSerializable<Column> {
    /*
     * Name of the Cosmos DB Cassandra table column
     */
    private String name;

    /*
     * Type of the Cosmos DB Cassandra table column
     */
    private String type;

    /**
     * Creates an instance of Column class.
     */
    public Column() {
    }

    /**
     * Get the name property: Name of the Cosmos DB Cassandra table column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Cosmos DB Cassandra table column.
     * 
     * @param name the name value to set.
     * @return the Column object itself.
     */
    public Column withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of the Cosmos DB Cassandra table column.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the Cosmos DB Cassandra table column.
     * 
     * @param type the type value to set.
     * @return the Column object itself.
     */
    public Column withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Column from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Column if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Column.
     */
    public static Column fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Column deserializedColumn = new Column();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedColumn.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedColumn.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedColumn;
        });
    }
}
