// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The system generated resource properties associated with SQL databases, SQL containers, Gremlin databases and Gremlin
 * graphs.
 */
@Immutable
public class ExtendedResourceProperties implements JsonSerializable<ExtendedResourceProperties> {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of ExtendedResourceProperties class.
     */
    public ExtendedResourceProperties() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Set the rid property: A system generated property. A unique identifier.
     * 
     * @param rid the rid value to set.
     * @return the ExtendedResourceProperties object itself.
     */
    ExtendedResourceProperties withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Set the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @param ts the ts value to set.
     * @return the ExtendedResourceProperties object itself.
     */
    ExtendedResourceProperties withTs(Float ts) {
        this.ts = ts;
        return this;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @param etag the etag value to set.
     * @return the ExtendedResourceProperties object itself.
     */
    ExtendedResourceProperties withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExtendedResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExtendedResourceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExtendedResourceProperties.
     */
    public static ExtendedResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExtendedResourceProperties deserializedExtendedResourceProperties = new ExtendedResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("_rid".equals(fieldName)) {
                    deserializedExtendedResourceProperties.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedExtendedResourceProperties.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedExtendedResourceProperties.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExtendedResourceProperties;
        });
    }
}
