// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseGetResultsInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the Gremlin databases and their properties.
 */
@Immutable
public final class GremlinDatabaseListResult implements JsonSerializable<GremlinDatabaseListResult> {
    /*
     * List of Gremlin databases and their properties.
     */
    private List<GremlinDatabaseGetResultsInner> value;

    /**
     * Creates an instance of GremlinDatabaseListResult class.
     */
    public GremlinDatabaseListResult() {
    }

    /**
     * Get the value property: List of Gremlin databases and their properties.
     * 
     * @return the value value.
     */
    public List<GremlinDatabaseGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GremlinDatabaseListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GremlinDatabaseListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GremlinDatabaseListResult.
     */
    public static GremlinDatabaseListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GremlinDatabaseListResult deserializedGremlinDatabaseListResult = new GremlinDatabaseListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GremlinDatabaseGetResultsInner> value
                        = reader.readArray(reader1 -> GremlinDatabaseGetResultsInner.fromJson(reader1));
                    deserializedGremlinDatabaseListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGremlinDatabaseListResult;
        });
    }
}
