/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AutoscaleSettings;
import java.io.IOException;

public final class CreateUpdateOptions
implements JsonSerializable<CreateUpdateOptions> {
    private Integer throughput;
    private AutoscaleSettings autoscaleSettings;

    public Integer throughput() {
        return this.throughput;
    }

    public CreateUpdateOptions withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    public AutoscaleSettings autoscaleSettings() {
        return this.autoscaleSettings;
    }

    public CreateUpdateOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        this.autoscaleSettings = autoscaleSettings;
        return this;
    }

    public void validate() {
        if (this.autoscaleSettings() != null) {
            this.autoscaleSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", (Number)this.throughput);
        jsonWriter.writeJsonField("autoscaleSettings", (JsonSerializable)this.autoscaleSettings);
        return jsonWriter.writeEndObject();
    }

    public static CreateUpdateOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CreateUpdateOptions)jsonReader.readObject(reader -> {
            CreateUpdateOptions deserializedCreateUpdateOptions = new CreateUpdateOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("throughput".equals(fieldName)) {
                    deserializedCreateUpdateOptions.throughput = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoscaleSettings".equals(fieldName)) {
                    deserializedCreateUpdateOptions.autoscaleSettings = AutoscaleSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateUpdateOptions;
        });
    }
}

