/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.PrivilegeResource;
import java.io.IOException;
import java.util.List;

public final class Privilege
implements JsonSerializable<Privilege> {
    private PrivilegeResource resource;
    private List<String> actions;

    public PrivilegeResource resource() {
        return this.resource;
    }

    public Privilege withResource(PrivilegeResource resource) {
        this.resource = resource;
        return this;
    }

    public List<String> actions() {
        return this.actions;
    }

    public Privilege withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.resource() != null) {
            this.resource().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Privilege fromJson(JsonReader jsonReader) throws IOException {
        return (Privilege)jsonReader.readObject(reader -> {
            Privilege deserializedPrivilege = new Privilege();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedPrivilege.resource = PrivilegeResource.fromJson(reader);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedPrivilege.actions = actions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivilege;
        });
    }
}

