/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlTriggerResource;
import java.io.IOException;
import java.util.Map;

public final class SqlTriggerCreateUpdateParameters
extends ArmResourceProperties {
    private SqlTriggerCreateUpdateProperties innerProperties = new SqlTriggerCreateUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SqlTriggerCreateUpdateParameters.class);

    private SqlTriggerCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public SqlTriggerCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SqlTriggerCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public SqlTriggerResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public SqlTriggerCreateUpdateParameters withResource(SqlTriggerResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlTriggerCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public SqlTriggerCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlTriggerCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SqlTriggerCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SqlTriggerCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SqlTriggerCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            SqlTriggerCreateUpdateParameters deserializedSqlTriggerCreateUpdateParameters = new SqlTriggerCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlTriggerCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSqlTriggerCreateUpdateParameters.innerProperties = SqlTriggerCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlTriggerCreateUpdateParameters;
        }));
    }
}

