// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specific Databases to restore.
 */
@Fluent
public final class RestorableGremlinResourcesGetResultInner
    implements JsonSerializable<RestorableGremlinResourcesGetResultInner> {
    /*
     * The unique resource identifier of the ARM resource.
     */
    private String id;

    /*
     * The name of the ARM resource.
     */
    private String name;

    /*
     * The type of Azure resource.
     */
    private String type;

    /*
     * The name of the gremlin database available for restore.
     */
    private String databaseName;

    /*
     * The names of the graphs available for restore.
     */
    private List<String> graphNames;

    /**
     * Creates an instance of RestorableGremlinResourcesGetResultInner class.
     */
    public RestorableGremlinResourcesGetResultInner() {
    }

    /**
     * Get the id property: The unique resource identifier of the ARM resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the databaseName property: The name of the gremlin database available for restore.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: The name of the gremlin database available for restore.
     * 
     * @param databaseName the databaseName value to set.
     * @return the RestorableGremlinResourcesGetResultInner object itself.
     */
    public RestorableGremlinResourcesGetResultInner withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the graphNames property: The names of the graphs available for restore.
     * 
     * @return the graphNames value.
     */
    public List<String> graphNames() {
        return this.graphNames;
    }

    /**
     * Set the graphNames property: The names of the graphs available for restore.
     * 
     * @param graphNames the graphNames value to set.
     * @return the RestorableGremlinResourcesGetResultInner object itself.
     */
    public RestorableGremlinResourcesGetResultInner withGraphNames(List<String> graphNames) {
        this.graphNames = graphNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("graphNames", this.graphNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableGremlinResourcesGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableGremlinResourcesGetResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableGremlinResourcesGetResultInner.
     */
    public static RestorableGremlinResourcesGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableGremlinResourcesGetResultInner deserializedRestorableGremlinResourcesGetResultInner
                = new RestorableGremlinResourcesGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorableGremlinResourcesGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorableGremlinResourcesGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorableGremlinResourcesGetResultInner.type = reader.getString();
                } else if ("databaseName".equals(fieldName)) {
                    deserializedRestorableGremlinResourcesGetResultInner.databaseName = reader.getString();
                } else if ("graphNames".equals(fieldName)) {
                    List<String> graphNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedRestorableGremlinResourcesGetResultInner.graphNames = graphNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableGremlinResourcesGetResultInner;
        });
    }
}
