// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The indexes for the path.
 */
@Fluent
public final class Indexes implements JsonSerializable<Indexes> {
    /*
     * The datatype for which the indexing behavior is applied to.
     */
    private DataType dataType;

    /*
     * The precision of the index. -1 is maximum precision.
     */
    private Integer precision;

    /*
     * Indicates the type of index.
     */
    private IndexKind kind;

    /**
     * Creates an instance of Indexes class.
     */
    public Indexes() {
    }

    /**
     * Get the dataType property: The datatype for which the indexing behavior is applied to.
     * 
     * @return the dataType value.
     */
    public DataType dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: The datatype for which the indexing behavior is applied to.
     * 
     * @param dataType the dataType value to set.
     * @return the Indexes object itself.
     */
    public Indexes withDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Get the precision property: The precision of the index. -1 is maximum precision.
     * 
     * @return the precision value.
     */
    public Integer precision() {
        return this.precision;
    }

    /**
     * Set the precision property: The precision of the index. -1 is maximum precision.
     * 
     * @param precision the precision value to set.
     * @return the Indexes object itself.
     */
    public Indexes withPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    /**
     * Get the kind property: Indicates the type of index.
     * 
     * @return the kind value.
     */
    public IndexKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Indicates the type of index.
     * 
     * @param kind the kind value to set.
     * @return the Indexes object itself.
     */
    public Indexes withKind(IndexKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeNumberField("precision", this.precision);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Indexes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Indexes if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Indexes.
     */
    public static Indexes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Indexes deserializedIndexes = new Indexes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataType".equals(fieldName)) {
                    deserializedIndexes.dataType = DataType.fromString(reader.getString());
                } else if ("precision".equals(fieldName)) {
                    deserializedIndexes.precision = reader.getNullable(JsonReader::getInt);
                } else if ("kind".equals(fieldName)) {
                    deserializedIndexes.kind = IndexKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIndexes;
        });
    }
}
