// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * IpAddressOrRange object.
 */
@Fluent
public final class IpAddressOrRange implements JsonSerializable<IpAddressOrRange> {
    /*
     * A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and
     * cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10, 172.16.0.0/12, 192.168.0.0/16,
     * since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245” or
     * “23.40.210.0/8”.
     */
    private String ipAddressOrRange;

    /**
     * Creates an instance of IpAddressOrRange class.
     */
    public IpAddressOrRange() {
    }

    /**
     * Get the ipAddressOrRange property: A single IPv4 address or a single IPv4 address range in CIDR format. Provided
     * IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10,
     * 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs:
     * “23.40.210.245” or “23.40.210.0/8”.
     * 
     * @return the ipAddressOrRange value.
     */
    public String ipAddressOrRange() {
        return this.ipAddressOrRange;
    }

    /**
     * Set the ipAddressOrRange property: A single IPv4 address or a single IPv4 address range in CIDR format. Provided
     * IPs must be well-formatted and cannot be contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10,
     * 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs:
     * “23.40.210.245” or “23.40.210.0/8”.
     * 
     * @param ipAddressOrRange the ipAddressOrRange value to set.
     * @return the IpAddressOrRange object itself.
     */
    public IpAddressOrRange withIpAddressOrRange(String ipAddressOrRange) {
        this.ipAddressOrRange = ipAddressOrRange;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddressOrRange", this.ipAddressOrRange);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAddressOrRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAddressOrRange if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpAddressOrRange.
     */
    public static IpAddressOrRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAddressOrRange deserializedIpAddressOrRange = new IpAddressOrRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddressOrRange".equals(fieldName)) {
                    deserializedIpAddressOrRange.ipAddressOrRange = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAddressOrRange;
        });
    }
}
