// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB MongoDB collection index key.
 */
@Fluent
public final class MongoIndex implements JsonSerializable<MongoIndex> {
    /*
     * Cosmos DB MongoDB collection index keys
     */
    private MongoIndexKeys key;

    /*
     * Cosmos DB MongoDB collection index key options
     */
    private MongoIndexOptions options;

    /**
     * Creates an instance of MongoIndex class.
     */
    public MongoIndex() {
    }

    /**
     * Get the key property: Cosmos DB MongoDB collection index keys.
     * 
     * @return the key value.
     */
    public MongoIndexKeys key() {
        return this.key;
    }

    /**
     * Set the key property: Cosmos DB MongoDB collection index keys.
     * 
     * @param key the key value to set.
     * @return the MongoIndex object itself.
     */
    public MongoIndex withKey(MongoIndexKeys key) {
        this.key = key;
        return this;
    }

    /**
     * Get the options property: Cosmos DB MongoDB collection index key options.
     * 
     * @return the options value.
     */
    public MongoIndexOptions options() {
        return this.options;
    }

    /**
     * Set the options property: Cosmos DB MongoDB collection index key options.
     * 
     * @param options the options value to set.
     * @return the MongoIndex object itself.
     */
    public MongoIndex withOptions(MongoIndexOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (key() != null) {
            key().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeJsonField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoIndex from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoIndex if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the MongoIndex.
     */
    public static MongoIndex fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoIndex deserializedMongoIndex = new MongoIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedMongoIndex.key = MongoIndexKeys.fromJson(reader);
                } else if ("options".equals(fieldName)) {
                    deserializedMongoIndex.options = MongoIndexOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoIndex;
        });
    }
}
