// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of the connection string.
 */
public final class Type extends ExpandableStringEnum<Type> {
    /**
     * Static value Sql for Type.
     */
    public static final Type SQL = fromString("Sql");

    /**
     * Static value Table for Type.
     */
    public static final Type TABLE = fromString("Table");

    /**
     * Static value MongoDB for Type.
     */
    public static final Type MONGO_DB = fromString("MongoDB");

    /**
     * Static value Cassandra for Type.
     */
    public static final Type CASSANDRA = fromString("Cassandra");

    /**
     * Static value CassandraConnectorMetadata for Type.
     */
    public static final Type CASSANDRA_CONNECTOR_METADATA = fromString("CassandraConnectorMetadata");

    /**
     * Static value Gremlin for Type.
     */
    public static final Type GREMLIN = fromString("Gremlin");

    /**
     * Static value SqlDedicatedGateway for Type.
     */
    public static final Type SQL_DEDICATED_GATEWAY = fromString("SqlDedicatedGateway");

    /**
     * Static value GremlinV2 for Type.
     */
    public static final Type GREMLIN_V2 = fromString("GremlinV2");

    /**
     * Static value Undefined for Type.
     */
    public static final Type UNDEFINED = fromString("Undefined");

    /**
     * Creates a new instance of Type value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Type() {
    }

    /**
     * Creates or finds a Type from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Type.
     */
    public static Type fromString(String name) {
        return fromString(name, Type.class);
    }

    /**
     * Gets known Type values.
     * 
     * @return known Type values.
     */
    public static Collection<Type> values() {
        return values(Type.class);
    }
}
