// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.MetricValue;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Metric data.
 */
@Immutable
public class MetricInner implements JsonSerializable<MetricInner> {
    /*
     * The start time for the metric (ISO-8601 format).
     */
    private OffsetDateTime startTime;

    /*
     * The end time for the metric (ISO-8601 format).
     */
    private OffsetDateTime endTime;

    /*
     * The time grain to be used to summarize the metric values.
     */
    private String timeGrain;

    /*
     * The unit of the metric.
     */
    private UnitType unit;

    /*
     * The name information for the metric.
     */
    private MetricName name;

    /*
     * The metric values for the specified time window and timestep.
     */
    private List<MetricValue> metricValues;

    /**
     * Creates an instance of MetricInner class.
     */
    public MetricInner() {
    }

    /**
     * Get the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time for the metric (ISO-8601 format).
     * 
     * @param startTime the startTime value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The end time for the metric (ISO-8601 format).
     * 
     * @param endTime the endTime value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the timeGrain property: The time grain to be used to summarize the metric values.
     * 
     * @return the timeGrain value.
     */
    public String timeGrain() {
        return this.timeGrain;
    }

    /**
     * Set the timeGrain property: The time grain to be used to summarize the metric values.
     * 
     * @param timeGrain the timeGrain value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    /**
     * Get the unit property: The unit of the metric.
     * 
     * @return the unit value.
     */
    public UnitType unit() {
        return this.unit;
    }

    /**
     * Set the unit property: The unit of the metric.
     * 
     * @param unit the unit value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withUnit(UnitType unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the name property: The name information for the metric.
     * 
     * @return the name value.
     */
    public MetricName name() {
        return this.name;
    }

    /**
     * Set the name property: The name information for the metric.
     * 
     * @param name the name value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withName(MetricName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the metricValues property: The metric values for the specified time window and timestep.
     * 
     * @return the metricValues value.
     */
    public List<MetricValue> metricValues() {
        return this.metricValues;
    }

    /**
     * Set the metricValues property: The metric values for the specified time window and timestep.
     * 
     * @param metricValues the metricValues value to set.
     * @return the MetricInner object itself.
     */
    MetricInner withMetricValues(List<MetricValue> metricValues) {
        this.metricValues = metricValues;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
        if (metricValues() != null) {
            metricValues().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricInner.
     */
    public static MetricInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricInner deserializedMetricInner = new MetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedMetricInner.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedMetricInner.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeGrain".equals(fieldName)) {
                    deserializedMetricInner.timeGrain = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedMetricInner.unit = UnitType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedMetricInner.name = MetricName.fromJson(reader);
                } else if ("metricValues".equals(fieldName)) {
                    List<MetricValue> metricValues = reader.readArray(reader1 -> MetricValue.fromJson(reader1));
                    deserializedMetricInner.metricValues = metricValues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricInner;
        });
    }
}
