// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the regional restorable account.
 */
@Fluent
public final class ContinuousBackupRestoreLocation implements JsonSerializable<ContinuousBackupRestoreLocation> {
    /*
     * The name of the continuous backup restore location.
     */
    private String location;

    /**
     * Creates an instance of ContinuousBackupRestoreLocation class.
     */
    public ContinuousBackupRestoreLocation() {
    }

    /**
     * Get the location property: The name of the continuous backup restore location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The name of the continuous backup restore location.
     * 
     * @param location the location value to set.
     * @return the ContinuousBackupRestoreLocation object itself.
     */
    public ContinuousBackupRestoreLocation withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinuousBackupRestoreLocation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinuousBackupRestoreLocation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContinuousBackupRestoreLocation.
     */
    public static ContinuousBackupRestoreLocation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinuousBackupRestoreLocation deserializedContinuousBackupRestoreLocation
                = new ContinuousBackupRestoreLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedContinuousBackupRestoreLocation.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinuousBackupRestoreLocation;
        });
    }
}
