// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The set of data plane operations permitted through this Role Definition.
 */
@Fluent
public final class Permission implements JsonSerializable<Permission> {
    /*
     * An array of data actions that are allowed.
     */
    private List<String> dataActions;

    /*
     * An array of data actions that are denied.
     */
    private List<String> notDataActions;

    /**
     * Creates an instance of Permission class.
     */
    public Permission() {
    }

    /**
     * Get the dataActions property: An array of data actions that are allowed.
     * 
     * @return the dataActions value.
     */
    public List<String> dataActions() {
        return this.dataActions;
    }

    /**
     * Set the dataActions property: An array of data actions that are allowed.
     * 
     * @param dataActions the dataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withDataActions(List<String> dataActions) {
        this.dataActions = dataActions;
        return this;
    }

    /**
     * Get the notDataActions property: An array of data actions that are denied.
     * 
     * @return the notDataActions value.
     */
    public List<String> notDataActions() {
        return this.notDataActions;
    }

    /**
     * Set the notDataActions property: An array of data actions that are denied.
     * 
     * @param notDataActions the notDataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withNotDataActions(List<String> notDataActions) {
        this.notDataActions = notDataActions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dataActions", this.dataActions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("notDataActions", this.notDataActions,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Permission from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Permission if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Permission.
     */
    public static Permission fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Permission deserializedPermission = new Permission();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataActions".equals(fieldName)) {
                    List<String> dataActions = reader.readArray(reader1 -> reader1.getString());
                    deserializedPermission.dataActions = dataActions;
                } else if ("notDataActions".equals(fieldName)) {
                    List<String> notDataActions = reader.readArray(reader1 -> reader1.getString());
                    deserializedPermission.notDataActions = notDataActions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPermission;
        });
    }
}
