/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MongoRoleDefinitionType;
import com.azure.resourcemanager.cosmos.models.Privilege;
import com.azure.resourcemanager.cosmos.models.Role;
import java.io.IOException;
import java.util.List;

public final class MongoRoleDefinitionResource
implements JsonSerializable<MongoRoleDefinitionResource> {
    private String roleName;
    private MongoRoleDefinitionType type;
    private String databaseName;
    private List<Privilege> privileges;
    private List<Role> roles;

    public String roleName() {
        return this.roleName;
    }

    public MongoRoleDefinitionResource withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    public MongoRoleDefinitionType type() {
        return this.type;
    }

    public MongoRoleDefinitionResource withType(MongoRoleDefinitionType type) {
        this.type = type;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MongoRoleDefinitionResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public List<Privilege> privileges() {
        return this.privileges;
    }

    public MongoRoleDefinitionResource withPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public MongoRoleDefinitionResource withRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    public void validate() {
        if (this.privileges() != null) {
            this.privileges().forEach(e -> e.validate());
        }
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleName", this.roleName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MongoRoleDefinitionResource fromJson(JsonReader jsonReader) throws IOException {
        return (MongoRoleDefinitionResource)jsonReader.readObject(reader -> {
            MongoRoleDefinitionResource deserializedMongoRoleDefinitionResource = new MongoRoleDefinitionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleName".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.roleName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.type = MongoRoleDefinitionType.fromString(reader.getString());
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMongoRoleDefinitionResource.databaseName = reader.getString();
                    continue;
                }
                if ("privileges".equals(fieldName)) {
                    List privileges;
                    deserializedMongoRoleDefinitionResource.privileges = privileges = reader.readArray(reader1 -> Privilege.fromJson(reader1));
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedMongoRoleDefinitionResource.roles = roles = reader.readArray(reader1 -> Role.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoRoleDefinitionResource;
        });
    }
}

