/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.VectorEmbedding;
import java.io.IOException;
import java.util.List;

public final class VectorEmbeddingPolicy
implements JsonSerializable<VectorEmbeddingPolicy> {
    private List<VectorEmbedding> vectorEmbeddings;

    public List<VectorEmbedding> vectorEmbeddings() {
        return this.vectorEmbeddings;
    }

    public VectorEmbeddingPolicy withVectorEmbeddings(List<VectorEmbedding> vectorEmbeddings) {
        this.vectorEmbeddings = vectorEmbeddings;
        return this;
    }

    public void validate() {
        if (this.vectorEmbeddings() != null) {
            this.vectorEmbeddings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vectorEmbeddings", this.vectorEmbeddings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VectorEmbeddingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (VectorEmbeddingPolicy)jsonReader.readObject(reader -> {
            VectorEmbeddingPolicy deserializedVectorEmbeddingPolicy = new VectorEmbeddingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vectorEmbeddings".equals(fieldName)) {
                    List vectorEmbeddings;
                    deserializedVectorEmbeddingPolicy.vectorEmbeddings = vectorEmbeddings = reader.readArray(reader1 -> VectorEmbedding.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVectorEmbeddingPolicy;
        });
    }
}

