/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.resourcemanager.cosmos.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.cosmos.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBAccountImpl;
import com.azure.resourcemanager.cosmos.models.CosmosDBAccount;
import com.azure.resourcemanager.cosmos.models.PrivateEndpointConnection;
import com.azure.resourcemanager.cosmos.models.PrivateEndpointProperty;
import com.azure.resourcemanager.cosmos.models.PrivateLinkServiceConnectionStateProperty;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import reactor.core.publisher.Mono;

public class PrivateEndpointConnectionImpl
extends ExternalChildResourceImpl<PrivateEndpointConnection, PrivateEndpointConnectionInner, CosmosDBAccountImpl, CosmosDBAccount>
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition<CosmosDBAccount.DefinitionStages.WithCreate>,
PrivateEndpointConnection.UpdateDefinition<CosmosDBAccount.UpdateStages.WithOptionals>,
PrivateEndpointConnection.Update {
    private final PrivateEndpointConnectionsClient client;

    PrivateEndpointConnectionImpl(String name, CosmosDBAccountImpl parent, PrivateEndpointConnectionInner inner, PrivateEndpointConnectionsClient client) {
        super(name, (Object)parent, (Object)inner);
        this.client = client;
    }

    public String id() {
        return ((PrivateEndpointConnectionInner)((Object)this.innerModel())).id();
    }

    @Override
    public PrivateEndpointProperty privateEndpoint() {
        return ((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return ((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateLinkServiceConnectionState();
    }

    @Override
    public PrivateEndpointConnectionImpl withStateProperty(PrivateLinkServiceConnectionStateProperty property) {
        ((PrivateEndpointConnectionInner)((Object)this.innerModel())).withPrivateLinkServiceConnectionState(property);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withStatus(String status) {
        if (((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateLinkServiceConnectionState() == null) {
            ((PrivateEndpointConnectionInner)((Object)this.innerModel())).withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionStateProperty());
        }
        ((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateLinkServiceConnectionState().withStatus(status);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withDescription(String description) {
        if (((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateLinkServiceConnectionState() == null) {
            ((PrivateEndpointConnectionInner)((Object)this.innerModel())).withPrivateLinkServiceConnectionState(new PrivateLinkServiceConnectionStateProperty());
        }
        ((PrivateEndpointConnectionInner)((Object)this.innerModel())).privateLinkServiceConnectionState().withDescription(description);
        return this;
    }

    public Mono<PrivateEndpointConnection> createResourceAsync() {
        PrivateEndpointConnectionImpl self = this;
        return this.client.createOrUpdateAsync(((CosmosDBAccountImpl)this.parent()).resourceGroupName(), ((CosmosDBAccountImpl)this.parent()).name(), this.name(), (PrivateEndpointConnectionInner)((Object)this.innerModel())).map(privateEndpointConnectionInner -> {
            self.setInner(privateEndpointConnectionInner);
            return self;
        });
    }

    public Mono<PrivateEndpointConnection> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return this.client.deleteAsync(((CosmosDBAccountImpl)this.parent()).resourceGroupName(), ((CosmosDBAccountImpl)this.parent()).name(), this.name());
    }

    protected Mono<PrivateEndpointConnectionInner> getInnerAsync() {
        return this.client.getAsync(((CosmosDBAccountImpl)this.parent()).resourceGroupName(), ((CosmosDBAccountImpl)this.parent()).name(), this.name());
    }

    public CosmosDBAccountImpl attach() {
        return ((CosmosDBAccountImpl)this.parent()).withPrivateEndpointConnection(this);
    }
}

