/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MongoIndexKeys;
import com.azure.resourcemanager.cosmos.models.MongoIndexOptions;
import java.io.IOException;

public final class MongoIndex
implements JsonSerializable<MongoIndex> {
    private MongoIndexKeys key;
    private MongoIndexOptions options;

    public MongoIndexKeys key() {
        return this.key;
    }

    public MongoIndex withKey(MongoIndexKeys key) {
        this.key = key;
        return this;
    }

    public MongoIndexOptions options() {
        return this.options;
    }

    public MongoIndex withOptions(MongoIndexOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.key() != null) {
            this.key().validate();
        }
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static MongoIndex fromJson(JsonReader jsonReader) throws IOException {
        return (MongoIndex)jsonReader.readObject(reader -> {
            MongoIndex deserializedMongoIndex = new MongoIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedMongoIndex.key = MongoIndexKeys.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedMongoIndex.options = MongoIndexOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoIndex;
        });
    }
}

