// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.RestorableTablePropertiesResource;
import java.io.IOException;

/**
 * An Azure Cosmos DB Table event.
 */
@Fluent
public final class RestorableTableGetResultInner implements JsonSerializable<RestorableTableGetResultInner> {
    /*
     * The properties of a Table event.
     */
    private RestorableTableProperties innerProperties;

    /*
     * The unique resource Identifier of the ARM resource.
     */
    private String id;

    /*
     * The name of the ARM resource.
     */
    private String name;

    /*
     * The type of Azure resource.
     */
    private String type;

    /**
     * Creates an instance of RestorableTableGetResultInner class.
     */
    public RestorableTableGetResultInner() {
    }

    /**
     * Get the innerProperties property: The properties of a Table event.
     * 
     * @return the innerProperties value.
     */
    private RestorableTableProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: The unique resource Identifier of the ARM resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the resource property: The resource of an Azure Cosmos DB Table event.
     * 
     * @return the resource value.
     */
    public RestorableTablePropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource of an Azure Cosmos DB Table event.
     * 
     * @param resource the resource value to set.
     * @return the RestorableTableGetResultInner object itself.
     */
    public RestorableTableGetResultInner withResource(RestorableTablePropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableTableProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableTableGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableTableGetResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableTableGetResultInner.
     */
    public static RestorableTableGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableTableGetResultInner deserializedRestorableTableGetResultInner
                = new RestorableTableGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedRestorableTableGetResultInner.innerProperties
                        = RestorableTableProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedRestorableTableGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorableTableGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorableTableGetResultInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableTableGetResultInner;
        });
    }
}
