// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB FullText Policy.
 */
@Fluent
public final class FullTextPolicy implements JsonSerializable<FullTextPolicy> {
    /*
     * The default language for a full text paths.
     */
    private String defaultLanguage;

    /*
     * List of FullText Paths
     */
    private List<FullTextPath> fullTextPaths;

    /**
     * Creates an instance of FullTextPolicy class.
     */
    public FullTextPolicy() {
    }

    /**
     * Get the defaultLanguage property: The default language for a full text paths.
     * 
     * @return the defaultLanguage value.
     */
    public String defaultLanguage() {
        return this.defaultLanguage;
    }

    /**
     * Set the defaultLanguage property: The default language for a full text paths.
     * 
     * @param defaultLanguage the defaultLanguage value to set.
     * @return the FullTextPolicy object itself.
     */
    public FullTextPolicy withDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    /**
     * Get the fullTextPaths property: List of FullText Paths.
     * 
     * @return the fullTextPaths value.
     */
    public List<FullTextPath> fullTextPaths() {
        return this.fullTextPaths;
    }

    /**
     * Set the fullTextPaths property: List of FullText Paths.
     * 
     * @param fullTextPaths the fullTextPaths value to set.
     * @return the FullTextPolicy object itself.
     */
    public FullTextPolicy withFullTextPaths(List<FullTextPath> fullTextPaths) {
        this.fullTextPaths = fullTextPaths;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (fullTextPaths() != null) {
            fullTextPaths().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultLanguage", this.defaultLanguage);
        jsonWriter.writeArrayField("fullTextPaths", this.fullTextPaths, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FullTextPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FullTextPolicy if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FullTextPolicy.
     */
    public static FullTextPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FullTextPolicy deserializedFullTextPolicy = new FullTextPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultLanguage".equals(fieldName)) {
                    deserializedFullTextPolicy.defaultLanguage = reader.getString();
                } else if ("fullTextPaths".equals(fieldName)) {
                    List<FullTextPath> fullTextPaths = reader.readArray(reader1 -> FullTextPath.fromJson(reader1));
                    deserializedFullTextPolicy.fullTextPaths = fullTextPaths;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFullTextPolicy;
        });
    }
}
