// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB SQL container resource object.
 */
@Fluent
public final class RestorableSqlContainerPropertiesResourceContainer extends SqlContainerResource {
    /*
     * A system generated property that specifies the addressable path of the container resource.
     */
    private String self;

    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of RestorableSqlContainerPropertiesResourceContainer class.
     */
    public RestorableSqlContainerPropertiesResourceContainer() {
    }

    /**
     * Get the self property: A system generated property that specifies the addressable path of the container resource.
     * 
     * @return the self value.
     */
    public String self() {
        return this.self;
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer
        withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer
        withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        super.withClientEncryptionPolicy(clientEncryptionPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer
        withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer
        withComputedProperties(List<ComputedProperty> computedProperties) {
        super.withComputedProperties(computedProperties);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer
        withVectorEmbeddingPolicy(VectorEmbeddingPolicy vectorEmbeddingPolicy) {
        super.withVectorEmbeddingPolicy(vectorEmbeddingPolicy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorableSqlContainerPropertiesResourceContainer withFullTextPolicy(FullTextPolicy fullTextPolicy) {
        super.withFullTextPolicy(fullTextPolicy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model RestorableSqlContainerPropertiesResourceContainer"));
        }
        if (indexingPolicy() != null) {
            indexingPolicy().validate();
        }
        if (partitionKey() != null) {
            partitionKey().validate();
        }
        if (uniqueKeyPolicy() != null) {
            uniqueKeyPolicy().validate();
        }
        if (conflictResolutionPolicy() != null) {
            conflictResolutionPolicy().validate();
        }
        if (clientEncryptionPolicy() != null) {
            clientEncryptionPolicy().validate();
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
        if (computedProperties() != null) {
            computedProperties().forEach(e -> e.validate());
        }
        if (vectorEmbeddingPolicy() != null) {
            vectorEmbeddingPolicy().validate();
        }
        if (fullTextPolicy() != null) {
            fullTextPolicy().validate();
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(RestorableSqlContainerPropertiesResourceContainer.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("indexingPolicy", indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", partitionKey());
        jsonWriter.writeNumberField("defaultTtl", defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", conflictResolutionPolicy());
        jsonWriter.writeJsonField("clientEncryptionPolicy", clientEncryptionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", restoreParameters());
        jsonWriter.writeStringField("createMode", createMode() == null ? null : createMode().toString());
        jsonWriter.writeArrayField("computedProperties", computedProperties(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("vectorEmbeddingPolicy", vectorEmbeddingPolicy());
        jsonWriter.writeJsonField("fullTextPolicy", fullTextPolicy());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlContainerPropertiesResourceContainer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlContainerPropertiesResourceContainer if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RestorableSqlContainerPropertiesResourceContainer.
     */
    public static RestorableSqlContainerPropertiesResourceContainer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlContainerPropertiesResourceContainer deserializedRestorableSqlContainerPropertiesResourceContainer
                = new RestorableSqlContainerPropertiesResourceContainer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.withId(reader.getString());
                } else if ("indexingPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withIndexingPolicy(IndexingPolicy.fromJson(reader));
                } else if ("partitionKey".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withPartitionKey(ContainerPartitionKey.fromJson(reader));
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withDefaultTtl(reader.getNullable(JsonReader::getInt));
                } else if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                } else if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                } else if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withClientEncryptionPolicy(ClientEncryptionPolicy.fromJson(reader));
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withAnalyticalStorageTtl(reader.getNullable(JsonReader::getLong));
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                } else if ("createMode".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withCreateMode(CreateMode.fromString(reader.getString()));
                } else if ("computedProperties".equals(fieldName)) {
                    List<ComputedProperty> computedProperties
                        = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withComputedProperties(computedProperties);
                } else if ("vectorEmbeddingPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withVectorEmbeddingPolicy(VectorEmbeddingPolicy.fromJson(reader));
                } else if ("fullTextPolicy".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer
                        .withFullTextPolicy(FullTextPolicy.fromJson(reader));
                } else if ("_self".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.self = reader.getString();
                } else if ("_rid".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.ts
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResourceContainer.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlContainerPropertiesResourceContainer;
        });
    }
}
