// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.TableGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.TableGetPropertiesResource;
import java.io.IOException;

/**
 * The properties of an Azure Cosmos Table.
 */
@Fluent
public final class TableGetProperties implements JsonSerializable<TableGetProperties> {
    /*
     * The resource property.
     */
    private TableGetPropertiesResource resource;

    /*
     * The options property.
     */
    private TableGetPropertiesOptions options;

    /**
     * Creates an instance of TableGetProperties class.
     */
    public TableGetProperties() {
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public TableGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the TableGetProperties object itself.
     */
    public TableGetProperties withResource(TableGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the options property: The options property.
     * 
     * @return the options value.
     */
    public TableGetPropertiesOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The options property.
     * 
     * @param options the options value to set.
     * @return the TableGetProperties object itself.
     */
    public TableGetProperties withOptions(TableGetPropertiesOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", this.resource);
        jsonWriter.writeJsonField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TableGetProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TableGetProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TableGetProperties.
     */
    public static TableGetProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TableGetProperties deserializedTableGetProperties = new TableGetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resource".equals(fieldName)) {
                    deserializedTableGetProperties.resource = TableGetPropertiesResource.fromJson(reader);
                } else if ("options".equals(fieldName)) {
                    deserializedTableGetProperties.options = TableGetPropertiesOptions.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTableGetProperties;
        });
    }
}
