// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resource of an Azure Cosmos DB Gremlin database event.
 */
@Immutable
public final class RestorableGremlinDatabasePropertiesResource
    implements JsonSerializable<RestorableGremlinDatabasePropertiesResource> {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * The operation type of this database event.
     */
    private OperationType operationType;

    /*
     * A state of this database to identify if this database is restorable in same account.
     */
    private String canUndelete;

    /*
     * The reason why this database can not be restored in same account.
     */
    private String canUndeleteReason;

    /*
     * The time when this database event happened.
     */
    private String eventTimestamp;

    /*
     * The name of this Gremlin database.
     */
    private String ownerId;

    /*
     * The resource ID of this Gremlin database.
     */
    private String ownerResourceId;

    /**
     * Creates an instance of RestorableGremlinDatabasePropertiesResource class.
     */
    public RestorableGremlinDatabasePropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the operationType property: The operation type of this database event.
     * 
     * @return the operationType value.
     */
    public OperationType operationType() {
        return this.operationType;
    }

    /**
     * Get the canUndelete property: A state of this database to identify if this database is restorable in same
     * account.
     * 
     * @return the canUndelete value.
     */
    public String canUndelete() {
        return this.canUndelete;
    }

    /**
     * Get the canUndeleteReason property: The reason why this database can not be restored in same account.
     * 
     * @return the canUndeleteReason value.
     */
    public String canUndeleteReason() {
        return this.canUndeleteReason;
    }

    /**
     * Get the eventTimestamp property: The time when this database event happened.
     * 
     * @return the eventTimestamp value.
     */
    public String eventTimestamp() {
        return this.eventTimestamp;
    }

    /**
     * Get the ownerId property: The name of this Gremlin database.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.ownerId;
    }

    /**
     * Get the ownerResourceId property: The resource ID of this Gremlin database.
     * 
     * @return the ownerResourceId value.
     */
    public String ownerResourceId() {
        return this.ownerResourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableGremlinDatabasePropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableGremlinDatabasePropertiesResource if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableGremlinDatabasePropertiesResource.
     */
    public static RestorableGremlinDatabasePropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableGremlinDatabasePropertiesResource deserializedRestorableGremlinDatabasePropertiesResource
                = new RestorableGremlinDatabasePropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("_rid".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.rid = reader.getString();
                } else if ("operationType".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.operationType
                        = OperationType.fromString(reader.getString());
                } else if ("canUndelete".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.canUndelete = reader.getString();
                } else if ("canUndeleteReason".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.canUndeleteReason = reader.getString();
                } else if ("eventTimestamp".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.eventTimestamp = reader.getString();
                } else if ("ownerId".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.ownerId = reader.getString();
                } else if ("ownerResourceId".equals(fieldName)) {
                    deserializedRestorableGremlinDatabasePropertiesResource.ownerResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableGremlinDatabasePropertiesResource;
        });
    }
}
