// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB SQL container resource object.
 */
@Fluent
public class SqlContainerResource implements JsonSerializable<SqlContainerResource> {
    /*
     * Name of the Cosmos DB SQL container
     */
    private String id;

    /*
     * The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the
     * container
     */
    private IndexingPolicy indexingPolicy;

    /*
     * The configuration of the partition key to be used for partitioning data into multiple partitions
     */
    private ContainerPartitionKey partitionKey;

    /*
     * Default time to live
     */
    private Integer defaultTtl;

    /*
     * The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the
     * Azure Cosmos DB service.
     */
    private UniqueKeyPolicy uniqueKeyPolicy;

    /*
     * The conflict resolution policy for the container.
     */
    private ConflictResolutionPolicy conflictResolutionPolicy;

    /*
     * The client encryption policy for the container.
     */
    private ClientEncryptionPolicy clientEncryptionPolicy;

    /*
     * Analytical TTL.
     */
    private Long analyticalStorageTtl;

    /*
     * Parameters to indicate the information about the restore
     */
    private ResourceRestoreParameters restoreParameters;

    /*
     * Enum to indicate the mode of resource creation.
     */
    private CreateMode createMode;

    /*
     * List of computed properties
     */
    private List<ComputedProperty> computedProperties;

    /*
     * The vector embedding policy for the container.
     */
    private VectorEmbeddingPolicy vectorEmbeddingPolicy;

    /*
     * The FullText policy for the container.
     */
    private FullTextPolicy fullTextPolicy;

    /**
     * Creates an instance of SqlContainerResource class.
     */
    public SqlContainerResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB SQL container.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB SQL container.
     * 
     * @param id the id value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the indexingPolicy property: The configuration of the indexing policy. By default, the indexing is automatic
     * for all document paths within the container.
     * 
     * @return the indexingPolicy value.
     */
    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    /**
     * Set the indexingPolicy property: The configuration of the indexing policy. By default, the indexing is automatic
     * for all document paths within the container.
     * 
     * @param indexingPolicy the indexingPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    /**
     * Get the partitionKey property: The configuration of the partition key to be used for partitioning data into
     * multiple partitions.
     * 
     * @return the partitionKey value.
     */
    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    /**
     * Set the partitionKey property: The configuration of the partition key to be used for partitioning data into
     * multiple partitions.
     * 
     * @param partitionKey the partitionKey value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    /**
     * Get the defaultTtl property: Default time to live.
     * 
     * @return the defaultTtl value.
     */
    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    /**
     * Set the defaultTtl property: Default time to live.
     * 
     * @param defaultTtl the defaultTtl value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    /**
     * Get the uniqueKeyPolicy property: The unique key policy configuration for specifying uniqueness constraints on
     * documents in the collection in the Azure Cosmos DB service.
     * 
     * @return the uniqueKeyPolicy value.
     */
    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    /**
     * Set the uniqueKeyPolicy property: The unique key policy configuration for specifying uniqueness constraints on
     * documents in the collection in the Azure Cosmos DB service.
     * 
     * @param uniqueKeyPolicy the uniqueKeyPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    /**
     * Get the conflictResolutionPolicy property: The conflict resolution policy for the container.
     * 
     * @return the conflictResolutionPolicy value.
     */
    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    /**
     * Set the conflictResolutionPolicy property: The conflict resolution policy for the container.
     * 
     * @param conflictResolutionPolicy the conflictResolutionPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    /**
     * Get the clientEncryptionPolicy property: The client encryption policy for the container.
     * 
     * @return the clientEncryptionPolicy value.
     */
    public ClientEncryptionPolicy clientEncryptionPolicy() {
        return this.clientEncryptionPolicy;
    }

    /**
     * Set the clientEncryptionPolicy property: The client encryption policy for the container.
     * 
     * @param clientEncryptionPolicy the clientEncryptionPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        this.clientEncryptionPolicy = clientEncryptionPolicy;
        return this;
    }

    /**
     * Get the analyticalStorageTtl property: Analytical TTL.
     * 
     * @return the analyticalStorageTtl value.
     */
    public Long analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    /**
     * Set the analyticalStorageTtl property: Analytical TTL.
     * 
     * @param analyticalStorageTtl the analyticalStorageTtl value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    /**
     * Get the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @return the restoreParameters value.
     */
    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    /**
     * Set the restoreParameters property: Parameters to indicate the information about the restore.
     * 
     * @param restoreParameters the restoreParameters value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    /**
     * Get the createMode property: Enum to indicate the mode of resource creation.
     * 
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode property: Enum to indicate the mode of resource creation.
     * 
     * @param createMode the createMode value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the computedProperties property: List of computed properties.
     * 
     * @return the computedProperties value.
     */
    public List<ComputedProperty> computedProperties() {
        return this.computedProperties;
    }

    /**
     * Set the computedProperties property: List of computed properties.
     * 
     * @param computedProperties the computedProperties value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withComputedProperties(List<ComputedProperty> computedProperties) {
        this.computedProperties = computedProperties;
        return this;
    }

    /**
     * Get the vectorEmbeddingPolicy property: The vector embedding policy for the container.
     * 
     * @return the vectorEmbeddingPolicy value.
     */
    public VectorEmbeddingPolicy vectorEmbeddingPolicy() {
        return this.vectorEmbeddingPolicy;
    }

    /**
     * Set the vectorEmbeddingPolicy property: The vector embedding policy for the container.
     * 
     * @param vectorEmbeddingPolicy the vectorEmbeddingPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withVectorEmbeddingPolicy(VectorEmbeddingPolicy vectorEmbeddingPolicy) {
        this.vectorEmbeddingPolicy = vectorEmbeddingPolicy;
        return this;
    }

    /**
     * Get the fullTextPolicy property: The FullText policy for the container.
     * 
     * @return the fullTextPolicy value.
     */
    public FullTextPolicy fullTextPolicy() {
        return this.fullTextPolicy;
    }

    /**
     * Set the fullTextPolicy property: The FullText policy for the container.
     * 
     * @param fullTextPolicy the fullTextPolicy value to set.
     * @return the SqlContainerResource object itself.
     */
    public SqlContainerResource withFullTextPolicy(FullTextPolicy fullTextPolicy) {
        this.fullTextPolicy = fullTextPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model SqlContainerResource"));
        }
        if (indexingPolicy() != null) {
            indexingPolicy().validate();
        }
        if (partitionKey() != null) {
            partitionKey().validate();
        }
        if (uniqueKeyPolicy() != null) {
            uniqueKeyPolicy().validate();
        }
        if (conflictResolutionPolicy() != null) {
            conflictResolutionPolicy().validate();
        }
        if (clientEncryptionPolicy() != null) {
            clientEncryptionPolicy().validate();
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
        if (computedProperties() != null) {
            computedProperties().forEach(e -> e.validate());
        }
        if (vectorEmbeddingPolicy() != null) {
            vectorEmbeddingPolicy().validate();
        }
        if (fullTextPolicy() != null) {
            fullTextPolicy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("indexingPolicy", this.indexingPolicy);
        jsonWriter.writeJsonField("partitionKey", this.partitionKey);
        jsonWriter.writeNumberField("defaultTtl", this.defaultTtl);
        jsonWriter.writeJsonField("uniqueKeyPolicy", this.uniqueKeyPolicy);
        jsonWriter.writeJsonField("conflictResolutionPolicy", this.conflictResolutionPolicy);
        jsonWriter.writeJsonField("clientEncryptionPolicy", this.clientEncryptionPolicy);
        jsonWriter.writeNumberField("analyticalStorageTtl", this.analyticalStorageTtl);
        jsonWriter.writeJsonField("restoreParameters", this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeArrayField("computedProperties", this.computedProperties,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("vectorEmbeddingPolicy", this.vectorEmbeddingPolicy);
        jsonWriter.writeJsonField("fullTextPolicy", this.fullTextPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlContainerResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlContainerResource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlContainerResource.
     */
    public static SqlContainerResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlContainerResource deserializedSqlContainerResource = new SqlContainerResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlContainerResource.id = reader.getString();
                } else if ("indexingPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.indexingPolicy = IndexingPolicy.fromJson(reader);
                } else if ("partitionKey".equals(fieldName)) {
                    deserializedSqlContainerResource.partitionKey = ContainerPartitionKey.fromJson(reader);
                } else if ("defaultTtl".equals(fieldName)) {
                    deserializedSqlContainerResource.defaultTtl = reader.getNullable(JsonReader::getInt);
                } else if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.uniqueKeyPolicy = UniqueKeyPolicy.fromJson(reader);
                } else if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.conflictResolutionPolicy
                        = ConflictResolutionPolicy.fromJson(reader);
                } else if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.clientEncryptionPolicy = ClientEncryptionPolicy.fromJson(reader);
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedSqlContainerResource.analyticalStorageTtl = reader.getNullable(JsonReader::getLong);
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlContainerResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                } else if ("createMode".equals(fieldName)) {
                    deserializedSqlContainerResource.createMode = CreateMode.fromString(reader.getString());
                } else if ("computedProperties".equals(fieldName)) {
                    List<ComputedProperty> computedProperties
                        = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    deserializedSqlContainerResource.computedProperties = computedProperties;
                } else if ("vectorEmbeddingPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.vectorEmbeddingPolicy = VectorEmbeddingPolicy.fromJson(reader);
                } else if ("fullTextPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.fullTextPolicy = FullTextPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlContainerResource;
        });
    }
}
