// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleDefinitionGetResultsInner;
import java.io.IOException;
import java.util.List;

/**
 * The relevant Role Definitions.
 */
@Immutable
public final class SqlRoleDefinitionListResult implements JsonSerializable<SqlRoleDefinitionListResult> {
    /*
     * List of Role Definitions and their properties.
     */
    private List<SqlRoleDefinitionGetResultsInner> value;

    /**
     * Creates an instance of SqlRoleDefinitionListResult class.
     */
    public SqlRoleDefinitionListResult() {
    }

    /**
     * Get the value property: List of Role Definitions and their properties.
     * 
     * @return the value value.
     */
    public List<SqlRoleDefinitionGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlRoleDefinitionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlRoleDefinitionListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SqlRoleDefinitionListResult.
     */
    public static SqlRoleDefinitionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlRoleDefinitionListResult deserializedSqlRoleDefinitionListResult = new SqlRoleDefinitionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SqlRoleDefinitionGetResultsInner> value
                        = reader.readArray(reader1 -> SqlRoleDefinitionGetResultsInner.fromJson(reader1));
                    deserializedSqlRoleDefinitionListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlRoleDefinitionListResult;
        });
    }
}
