/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RestorableDatabaseAccountGetResultInner
implements JsonSerializable<RestorableDatabaseAccountGetResultInner> {
    private RestorableDatabaseAccountProperties innerProperties;
    private String id;
    private String name;
    private String type;
    private String location;

    private RestorableDatabaseAccountProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public RestorableDatabaseAccountGetResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String accountName() {
        return this.innerProperties() == null ? null : this.innerProperties().accountName();
    }

    public RestorableDatabaseAccountGetResultInner withAccountName(String accountName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withAccountName(accountName);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public RestorableDatabaseAccountGetResultInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime deletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionTime();
    }

    public RestorableDatabaseAccountGetResultInner withDeletionTime(OffsetDateTime deletionTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withDeletionTime(deletionTime);
        return this;
    }

    public OffsetDateTime oldestRestorableTime() {
        return this.innerProperties() == null ? null : this.innerProperties().oldestRestorableTime();
    }

    public RestorableDatabaseAccountGetResultInner withOldestRestorableTime(OffsetDateTime oldestRestorableTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withOldestRestorableTime(oldestRestorableTime);
        return this;
    }

    public ApiType apiType() {
        return this.innerProperties() == null ? null : this.innerProperties().apiType();
    }

    public List<RestorableLocationResource> restorableLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableLocations();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static RestorableDatabaseAccountGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableDatabaseAccountGetResultInner)jsonReader.readObject(reader -> {
            RestorableDatabaseAccountGetResultInner deserializedRestorableDatabaseAccountGetResultInner = new RestorableDatabaseAccountGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountGetResultInner.innerProperties = RestorableDatabaseAccountProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountGetResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountGetResultInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountGetResultInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountGetResultInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableDatabaseAccountGetResultInner;
        });
    }
}

