// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Services response resource.
 */
@Fluent
public class ServiceResourceProperties implements JsonSerializable<ServiceResourceProperties> {
    /*
     * ServiceType for the service.
     */
    private ServiceType serviceType = ServiceType.fromString("ServiceResourceProperties");

    /*
     * Time of the last state change (ISO-8601 format).
     */
    private OffsetDateTime creationTime;

    /*
     * Instance type for the service.
     */
    private ServiceSize instanceSize;

    /*
     * Instance count for the service.
     */
    private Integer instanceCount;

    /*
     * Describes the status of a service.
     */
    private ServiceStatus status;

    /*
     * Services response resource.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ServiceResourceProperties class.
     */
    public ServiceResourceProperties() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * Get the creationTime property: Time of the last state change (ISO-8601 format).
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: Time of the last state change (ISO-8601 format).
     * 
     * @param creationTime the creationTime value to set.
     * @return the ServiceResourceProperties object itself.
     */
    ServiceResourceProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the instanceSize property: Instance type for the service.
     * 
     * @return the instanceSize value.
     */
    public ServiceSize instanceSize() {
        return this.instanceSize;
    }

    /**
     * Set the instanceSize property: Instance type for the service.
     * 
     * @param instanceSize the instanceSize value to set.
     * @return the ServiceResourceProperties object itself.
     */
    public ServiceResourceProperties withInstanceSize(ServiceSize instanceSize) {
        this.instanceSize = instanceSize;
        return this;
    }

    /**
     * Get the instanceCount property: Instance count for the service.
     * 
     * @return the instanceCount value.
     */
    public Integer instanceCount() {
        return this.instanceCount;
    }

    /**
     * Set the instanceCount property: Instance count for the service.
     * 
     * @param instanceCount the instanceCount value to set.
     * @return the ServiceResourceProperties object itself.
     */
    public ServiceResourceProperties withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    /**
     * Get the status property: Describes the status of a service.
     * 
     * @return the status value.
     */
    public ServiceStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Describes the status of a service.
     * 
     * @param status the status value to set.
     * @return the ServiceResourceProperties object itself.
     */
    ServiceResourceProperties withStatus(ServiceStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: Services response resource.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Services response resource.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ServiceResourceProperties object itself.
     */
    public ServiceResourceProperties withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("instanceSize", this.instanceSize == null ? null : this.instanceSize.toString());
        jsonWriter.writeNumberField("instanceCount", this.instanceCount);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceResourceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceResourceProperties.
     */
    public static ServiceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("serviceType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("DataTransfer".equals(discriminatorValue)) {
                    return DataTransferServiceResourceProperties.fromJson(readerToUse.reset());
                } else if ("SqlDedicatedGateway".equals(discriminatorValue)) {
                    return SqlDedicatedGatewayServiceResourceProperties.fromJson(readerToUse.reset());
                } else if ("GraphAPICompute".equals(discriminatorValue)) {
                    return GraphApiComputeServiceResourceProperties.fromJson(readerToUse.reset());
                } else if ("MaterializedViewsBuilder".equals(discriminatorValue)) {
                    return MaterializedViewsBuilderServiceResourceProperties.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static ServiceResourceProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceResourceProperties deserializedServiceResourceProperties = new ServiceResourceProperties();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceType".equals(fieldName)) {
                    deserializedServiceResourceProperties.serviceType = ServiceType.fromString(reader.getString());
                } else if ("creationTime".equals(fieldName)) {
                    deserializedServiceResourceProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("instanceSize".equals(fieldName)) {
                    deserializedServiceResourceProperties.instanceSize = ServiceSize.fromString(reader.getString());
                } else if ("instanceCount".equals(fieldName)) {
                    deserializedServiceResourceProperties.instanceCount = reader.getNullable(JsonReader::getInt);
                } else if ("status".equals(fieldName)) {
                    deserializedServiceResourceProperties.status = ServiceStatus.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedServiceResourceProperties.additionalProperties = additionalProperties;

            return deserializedServiceResourceProperties;
        });
    }
}
