/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.DataTransferServiceResourceCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GraphApiComputeServiceResourceCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.MaterializedViewsBuilderServiceResourceCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.ServiceSize;
import com.azure.resourcemanager.cosmos.models.ServiceType;
import com.azure.resourcemanager.cosmos.models.SqlDedicatedGatewayServiceResourceCreateUpdateParameters;
import java.io.IOException;

public class ServiceResourceCreateUpdateProperties
implements JsonSerializable<ServiceResourceCreateUpdateProperties> {
    private ServiceType serviceType = ServiceType.fromString("ServiceResourceCreateUpdateProperties");
    private ServiceSize instanceSize;
    private Integer instanceCount;

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public ServiceSize instanceSize() {
        return this.instanceSize;
    }

    public ServiceResourceCreateUpdateProperties withInstanceSize(ServiceSize instanceSize) {
        this.instanceSize = instanceSize;
        return this;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ServiceResourceCreateUpdateProperties withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceType", this.serviceType == null ? null : this.serviceType.toString());
        jsonWriter.writeStringField("instanceSize", this.instanceSize == null ? null : this.instanceSize.toString());
        jsonWriter.writeNumberField("instanceCount", (Number)this.instanceCount);
        return jsonWriter.writeEndObject();
    }

    public static ServiceResourceCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceResourceCreateUpdateProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Object fieldName;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("serviceType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DataTransfer".equals(discriminatorValue)) {
                    fieldName = DataTransferServiceResourceCreateUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("SqlDedicatedGateway".equals(discriminatorValue)) {
                    fieldName = SqlDedicatedGatewayServiceResourceCreateUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("GraphAPICompute".equals(discriminatorValue)) {
                    fieldName = GraphApiComputeServiceResourceCreateUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("MaterializedViewsBuilder".equals(discriminatorValue)) {
                    fieldName = MaterializedViewsBuilderServiceResourceCreateUpdateParameters.fromJson(readerToUse.reset());
                    return fieldName;
                }
                fieldName = ServiceResourceCreateUpdateProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return fieldName;
            }
        });
    }

    static ServiceResourceCreateUpdateProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ServiceResourceCreateUpdateProperties)jsonReader.readObject(reader -> {
            ServiceResourceCreateUpdateProperties deserializedServiceResourceCreateUpdateProperties = new ServiceResourceCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceType".equals(fieldName)) {
                    deserializedServiceResourceCreateUpdateProperties.serviceType = ServiceType.fromString(reader.getString());
                    continue;
                }
                if ("instanceSize".equals(fieldName)) {
                    deserializedServiceResourceCreateUpdateProperties.instanceSize = ServiceSize.fromString(reader.getString());
                    continue;
                }
                if ("instanceCount".equals(fieldName)) {
                    deserializedServiceResourceCreateUpdateProperties.instanceCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceResourceCreateUpdateProperties;
        });
    }
}

