/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionPolicy;
import com.azure.resourcemanager.cosmos.models.ComputedProperty;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.FullTextPolicy;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import com.azure.resourcemanager.cosmos.models.VectorEmbeddingPolicy;
import java.io.IOException;
import java.util.List;

public class SqlContainerResource
implements JsonSerializable<SqlContainerResource> {
    private String id;
    private IndexingPolicy indexingPolicy;
    private ContainerPartitionKey partitionKey;
    private Integer defaultTtl;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private ConflictResolutionPolicy conflictResolutionPolicy;
    private ClientEncryptionPolicy clientEncryptionPolicy;
    private Long analyticalStorageTtl;
    private ResourceRestoreParameters restoreParameters;
    private CreateMode createMode;
    private List<ComputedProperty> computedProperties;
    private VectorEmbeddingPolicy vectorEmbeddingPolicy;
    private FullTextPolicy fullTextPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(SqlContainerResource.class);

    public String id() {
        return this.id;
    }

    public SqlContainerResource withId(String id) {
        this.id = id;
        return this;
    }

    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    public SqlContainerResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    public SqlContainerResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    public SqlContainerResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    public SqlContainerResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public SqlContainerResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public ClientEncryptionPolicy clientEncryptionPolicy() {
        return this.clientEncryptionPolicy;
    }

    public SqlContainerResource withClientEncryptionPolicy(ClientEncryptionPolicy clientEncryptionPolicy) {
        this.clientEncryptionPolicy = clientEncryptionPolicy;
        return this;
    }

    public Long analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public SqlContainerResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public SqlContainerResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public SqlContainerResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public List<ComputedProperty> computedProperties() {
        return this.computedProperties;
    }

    public SqlContainerResource withComputedProperties(List<ComputedProperty> computedProperties) {
        this.computedProperties = computedProperties;
        return this;
    }

    public VectorEmbeddingPolicy vectorEmbeddingPolicy() {
        return this.vectorEmbeddingPolicy;
    }

    public SqlContainerResource withVectorEmbeddingPolicy(VectorEmbeddingPolicy vectorEmbeddingPolicy) {
        this.vectorEmbeddingPolicy = vectorEmbeddingPolicy;
        return this;
    }

    public FullTextPolicy fullTextPolicy() {
        return this.fullTextPolicy;
    }

    public SqlContainerResource withFullTextPolicy(FullTextPolicy fullTextPolicy) {
        this.fullTextPolicy = fullTextPolicy;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model SqlContainerResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.clientEncryptionPolicy() != null) {
            this.clientEncryptionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
        if (this.computedProperties() != null) {
            this.computedProperties().forEach(e -> e.validate());
        }
        if (this.vectorEmbeddingPolicy() != null) {
            this.vectorEmbeddingPolicy().validate();
        }
        if (this.fullTextPolicy() != null) {
            this.fullTextPolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("indexingPolicy", (JsonSerializable)this.indexingPolicy);
        jsonWriter.writeJsonField("partitionKey", (JsonSerializable)this.partitionKey);
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl);
        jsonWriter.writeJsonField("uniqueKeyPolicy", (JsonSerializable)this.uniqueKeyPolicy);
        jsonWriter.writeJsonField("conflictResolutionPolicy", (JsonSerializable)this.conflictResolutionPolicy);
        jsonWriter.writeJsonField("clientEncryptionPolicy", (JsonSerializable)this.clientEncryptionPolicy);
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl);
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeArrayField("computedProperties", this.computedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("vectorEmbeddingPolicy", (JsonSerializable)this.vectorEmbeddingPolicy);
        jsonWriter.writeJsonField("fullTextPolicy", (JsonSerializable)this.fullTextPolicy);
        return jsonWriter.writeEndObject();
    }

    public static SqlContainerResource fromJson(JsonReader jsonReader) throws IOException {
        return (SqlContainerResource)jsonReader.readObject(reader -> {
            SqlContainerResource deserializedSqlContainerResource = new SqlContainerResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSqlContainerResource.id = reader.getString();
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.indexingPolicy = IndexingPolicy.fromJson(reader);
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedSqlContainerResource.partitionKey = ContainerPartitionKey.fromJson(reader);
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedSqlContainerResource.defaultTtl = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.uniqueKeyPolicy = UniqueKeyPolicy.fromJson(reader);
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.conflictResolutionPolicy = ConflictResolutionPolicy.fromJson(reader);
                    continue;
                }
                if ("clientEncryptionPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.clientEncryptionPolicy = ClientEncryptionPolicy.fromJson(reader);
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedSqlContainerResource.analyticalStorageTtl = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedSqlContainerResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedSqlContainerResource.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("computedProperties".equals(fieldName)) {
                    List computedProperties;
                    deserializedSqlContainerResource.computedProperties = computedProperties = reader.readArray(reader1 -> ComputedProperty.fromJson(reader1));
                    continue;
                }
                if ("vectorEmbeddingPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.vectorEmbeddingPolicy = VectorEmbeddingPolicy.fromJson(reader);
                    continue;
                }
                if ("fullTextPolicy".equals(fieldName)) {
                    deserializedSqlContainerResource.fullTextPolicy = FullTextPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlContainerResource;
        });
    }
}

