/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetResourceProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;
import java.util.Map;

public final class FleetResourceInner
extends Resource {
    private FleetResourceProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private FleetResourceProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public FleetResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FleetResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public FleetResourceInner withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetResourceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FleetResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (FleetResourceInner)((Object)jsonReader.readObject(reader -> {
            FleetResourceInner deserializedFleetResourceInner = new FleetResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFleetResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFleetResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFleetResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFleetResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFleetResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFleetResourceInner.innerProperties = FleetResourceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFleetResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetResourceInner;
        }));
    }
}

