/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.FleetspaceAccountProperties;
import com.azure.resourcemanager.cosmos.models.FleetspaceAccountPropertiesGlobalDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;

public final class FleetspaceAccountResourceInner
extends ProxyResource {
    private FleetspaceAccountProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private FleetspaceAccountProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Status provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public FleetspaceAccountResourceInner withProvisioningState(Status provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceAccountProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().globalDatabaseAccountProperties();
    }

    public FleetspaceAccountResourceInner withGlobalDatabaseAccountProperties(FleetspaceAccountPropertiesGlobalDatabaseAccountProperties globalDatabaseAccountProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FleetspaceAccountProperties();
        }
        this.innerProperties().withGlobalDatabaseAccountProperties(globalDatabaseAccountProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FleetspaceAccountResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (FleetspaceAccountResourceInner)((Object)jsonReader.readObject(reader -> {
            FleetspaceAccountResourceInner deserializedFleetspaceAccountResourceInner = new FleetspaceAccountResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.innerProperties = FleetspaceAccountProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFleetspaceAccountResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetspaceAccountResourceInner;
        }));
    }
}

