/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.CollectionRegionsClient;
import com.azure.resourcemanager.cosmos.fluent.models.MetricInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.MetricListResult;
import reactor.core.publisher.Mono;

public final class CollectionRegionsClientImpl
implements CollectionRegionsClient {
    private final CollectionRegionsService service;
    private final CosmosDBManagementClientImpl client;

    CollectionRegionsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (CollectionRegionsService)RestProxy.create(CollectionRegionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (region == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter region is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, region, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (region == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter region is required and cannot be null."));
        }
        if (databaseRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseRid is required and cannot be null."));
        }
        if (collectionRid == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter collectionRid is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName, region, databaseRid, collectionRid, this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter, Context context) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementClientCollectionRegions")
    public static interface CollectionRegionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/databases/{databaseRid}/collections/{collectionRid}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricListResult>> listMetrics(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="accountName") String var4, @PathParam(value="region") String var5, @PathParam(value="databaseRid") String var6, @PathParam(value="collectionRid") String var7, @QueryParam(value="api-version") String var8, @QueryParam(value="$filter") String var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

