/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKind;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.RestoreParameters;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DatabaseAccountCreateUpdateParameters
extends ArmResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseAccountCreateUpdateParameters.class);
    @JsonProperty(value="kind")
    private DatabaseAccountKind kind;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties.consistencyPolicy")
    private ConsistencyPolicy consistencyPolicy;
    @JsonProperty(value="properties.locations", required=true)
    private List<Location> locations;
    @JsonProperty(value="properties.databaseAccountOfferType", required=true)
    private String databaseAccountOfferType = "Standard";
    @JsonProperty(value="properties.ipRules")
    private List<IpAddressOrRange> ipRules;
    @JsonProperty(value="properties.isVirtualNetworkFilterEnabled")
    private Boolean isVirtualNetworkFilterEnabled;
    @JsonProperty(value="properties.enableAutomaticFailover")
    private Boolean enableAutomaticFailover;
    @JsonProperty(value="properties.capabilities")
    private List<Capability> capabilities;
    @JsonProperty(value="properties.virtualNetworkRules")
    private List<VirtualNetworkRule> virtualNetworkRules;
    @JsonProperty(value="properties.enableMultipleWriteLocations")
    private Boolean enableMultipleWriteLocations;
    @JsonProperty(value="properties.enableCassandraConnector")
    private Boolean enableCassandraConnector;
    @JsonProperty(value="properties.connectorOffer")
    private ConnectorOffer connectorOffer;
    @JsonProperty(value="properties.disableKeyBasedMetadataWriteAccess")
    private Boolean disableKeyBasedMetadataWriteAccess;
    @JsonProperty(value="properties.keyVaultKeyUri")
    private String keyVaultKeyUri;
    @JsonProperty(value="properties.defaultIdentity")
    private String defaultIdentity;
    @JsonProperty(value="properties.publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="properties.enableFreeTier")
    private Boolean enableFreeTier;
    @JsonProperty(value="properties.apiProperties")
    private ApiProperties apiProperties;
    @JsonProperty(value="properties.enableAnalyticalStorage")
    private Boolean enableAnalyticalStorage;
    @JsonProperty(value="properties.analyticalStorageConfiguration")
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;
    @JsonProperty(value="properties.createMode")
    private CreateMode createMode;
    @JsonProperty(value="properties.backupPolicy")
    private BackupPolicy backupPolicy;
    @JsonProperty(value="properties.cors")
    private List<CorsPolicy> cors;
    @JsonProperty(value="properties.networkAclBypass")
    private NetworkAclBypass networkAclBypass;
    @JsonProperty(value="properties.networkAclBypassResourceIds")
    private List<String> networkAclBypassResourceIds;
    @JsonProperty(value="properties.disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="properties.restoreParameters")
    private RestoreParameters restoreParameters;

    public DatabaseAccountKind kind() {
        return this.kind;
    }

    public DatabaseAccountCreateUpdateParameters withKind(DatabaseAccountKind kind) {
        this.kind = kind;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public DatabaseAccountCreateUpdateParameters withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountCreateUpdateParameters withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public DatabaseAccountCreateUpdateParameters withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    public String databaseAccountOfferType() {
        return this.databaseAccountOfferType;
    }

    public DatabaseAccountCreateUpdateParameters withDatabaseAccountOfferType(String databaseAccountOfferType) {
        this.databaseAccountOfferType = databaseAccountOfferType;
        return this;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    public DatabaseAccountCreateUpdateParameters withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountCreateUpdateParameters withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountCreateUpdateParameters withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountCreateUpdateParameters withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountCreateUpdateParameters withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountCreateUpdateParameters withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountCreateUpdateParameters withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountCreateUpdateParameters withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountCreateUpdateParameters withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    public DatabaseAccountCreateUpdateParameters withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    public DatabaseAccountCreateUpdateParameters withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DatabaseAccountCreateUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    public DatabaseAccountCreateUpdateParameters withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    public DatabaseAccountCreateUpdateParameters withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    public DatabaseAccountCreateUpdateParameters withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    public DatabaseAccountCreateUpdateParameters withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseAccountCreateUpdateParameters withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    public DatabaseAccountCreateUpdateParameters withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.cors;
    }

    public DatabaseAccountCreateUpdateParameters withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    public DatabaseAccountCreateUpdateParameters withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    public DatabaseAccountCreateUpdateParameters withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DatabaseAccountCreateUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public RestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public DatabaseAccountCreateUpdateParameters withRestoreParameters(RestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    @Override
    public DatabaseAccountCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public DatabaseAccountCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.locations() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property locations in model DatabaseAccountCreateUpdateParameters"));
        }
        this.locations().forEach(e -> e.validate());
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.apiProperties() != null) {
            this.apiProperties().validate();
        }
        if (this.analyticalStorageConfiguration() != null) {
            this.analyticalStorageConfiguration().validate();
        }
        if (this.backupPolicy() != null) {
            this.backupPolicy().validate();
        }
        if (this.cors() != null) {
            this.cors().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }
}

