/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.RestorableSqlContainersClient;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableSqlContainerGetResultInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.RestorableSqlContainersListResult;
import reactor.core.publisher.Mono;

public final class RestorableSqlContainersClientImpl
implements RestorableSqlContainersClient {
    private final ClientLogger logger = new ClientLogger(RestorableSqlContainersClientImpl.class);
    private final RestorableSqlContainersService service;
    private final CosmosDBManagementClientImpl client;

    RestorableSqlContainersClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (RestorableSqlContainersService)RestProxy.create(RestorableSqlContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlContainerGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableSqlDatabaseRid, startTime, endTime, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlContainersListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableSqlContainerGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableSqlDatabaseRid, startTime, endTime, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableSqlContainersListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId) {
        String restorableSqlDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableSqlContainerGetResultInner> listAsync(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlContainerGetResultInner> list(String location, String instanceId) {
        String restorableSqlDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedIterable(this.listAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableSqlContainerGetResultInner> list(String location, String instanceId, String restorableSqlDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedIterable(this.listAsync(location, instanceId, restorableSqlDatabaseRid, startTime, endTime, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    private static interface RestorableSqlContainersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableSqlContainers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableSqlContainersListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @QueryParam(value="restorableSqlDatabaseRid") String var6, @QueryParam(value="startTime") String var7, @QueryParam(value="endTime") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

