// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.BackupInformationInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlContainerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleAssignmentGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleDefinitionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlStoredProcedureGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlUserDefinedFunctionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.ContinuousBackupRestoreLocation;
import com.azure.resourcemanager.cosmos.models.SqlContainerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlRoleAssignmentCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlRoleDefinitionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlTriggerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SqlResourcesClient. */
public interface SqlResourcesClient {
    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlDatabaseGetResultsInner> listSqlDatabasesAsync(String resourceGroupName, String accountName);

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName);

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(
        String resourceGroupName, String accountName, Context context);

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlDatabaseGetResultsInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlDatabaseGetResultsInner> getSqlDatabaseWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlDatabaseGetResultsInner createUpdateSqlDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters);

    /**
     * Create or update an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlDatabaseGetResultsInner createUpdateSqlDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName);

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner getSqlDatabaseThroughput(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscale(
            String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlDatabaseToAutoscale(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlDatabaseToAutoscale(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlDatabaseToManualThroughput(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlDatabaseToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlContainerGetResultsInner> listSqlContainersAsync(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlContainerGetResultsInner> listSqlContainers(
        String resourceGroupName, String accountName, String databaseName);

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlContainerGetResultsInner> listSqlContainers(
        String resourceGroupName, String accountName, String databaseName, Context context);

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlContainerGetResultsInner>> getSqlContainerWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlContainerGetResultsInner> getSqlContainerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlContainerGetResultsInner getSqlContainer(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlContainerGetResultsInner> getSqlContainerWithResponse(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainerWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainer(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner> beginCreateUpdateSqlContainer(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlContainerGetResultsInner createUpdateSqlContainer(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlContainerGetResultsInner createUpdateSqlContainer(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlContainerWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlContainerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlContainerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlContainer(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner getSqlContainerThroughput(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ThroughputSettingsGetResultsInner> getSqlContainerThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateSqlContainerThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters);

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner updateSqlContainerThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscaleAsync(
            String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscale(
            String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscale(
            String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlContainerToAutoscale(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlContainerToAutoscale(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlContainerToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ThroughputSettingsGetResultsInner migrateSqlContainerToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlStoredProcedureGetResultsInner> listSqlStoredProceduresAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlStoredProcedureGetResultsInner getSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureWithResponse(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedureWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedureAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedure(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedure(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters,
            Context context);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters);

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedureWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlStoredProcedureAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlStoredProcedureAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName);

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlStoredProcedure(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String storedProcedureName,
        Context context);

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctionsAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlUserDefinedFunctionGetResultsInner getSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionWithResponse(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunctionAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunction(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunction(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters,
            Context context);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters);

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     *     userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunctionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlUserDefinedFunctionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName);

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlUserDefinedFunction(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String userDefinedFunctionName,
        Context context);

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlTriggerGetResultsInner> listSqlTriggersAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(
        String resourceGroupName, String accountName, String databaseName, String containerName);

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context);

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlTriggerGetResultsInner>> getSqlTriggerWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlTriggerGetResultsInner> getSqlTriggerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlTriggerGetResultsInner getSqlTrigger(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlTriggerGetResultsInner> getSqlTriggerWithResponse(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTriggerWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters,
        Context context);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlTriggerGetResultsInner createUpdateSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters);

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlTriggerGetResultsInner createUpdateSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlTriggerWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlTriggerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlTriggerAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlTrigger(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName);

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlTrigger(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        String triggerName,
        Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlRoleDefinitionGetResultsInner>> getSqlRoleDefinitionWithResponseAsync(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlRoleDefinitionGetResultsInner> getSqlRoleDefinitionAsync(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleDefinitionGetResultsInner getSqlRoleDefinition(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlRoleDefinitionGetResultsInner> getSqlRoleDefinitionWithResponse(
        String roleDefinitionId, String resourceGroupName, String accountName, Context context);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleDefinitionWithResponseAsync(
        String roleDefinitionId,
        String resourceGroupName,
        String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinitionAsync(
            String roleDefinitionId,
            String resourceGroupName,
            String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinition(
            String roleDefinitionId,
            String resourceGroupName,
            String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinition(
            String roleDefinitionId,
            String resourceGroupName,
            String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters,
            Context context);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlRoleDefinitionGetResultsInner> createUpdateSqlRoleDefinitionAsync(
        String roleDefinitionId,
        String resourceGroupName,
        String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleDefinitionGetResultsInner createUpdateSqlRoleDefinition(
        String roleDefinitionId,
        String resourceGroupName,
        String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleDefinitionGetResultsInner createUpdateSqlRoleDefinition(
        String roleDefinitionId,
        String resourceGroupName,
        String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleDefinitionWithResponseAsync(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleDefinitionAsync(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleDefinition(
        String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleDefinition(
        String roleDefinitionId, String resourceGroupName, String accountName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlRoleDefinitionAsync(String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlRoleDefinition(String roleDefinitionId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     *
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlRoleDefinition(
        String roleDefinitionId, String resourceGroupName, String accountName, Context context);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitionsAsync(
        String resourceGroupName, String accountName);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitions(
        String resourceGroupName, String accountName);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitions(
        String resourceGroupName, String accountName, Context context);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SqlRoleAssignmentGetResultsInner>> getSqlRoleAssignmentWithResponseAsync(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlRoleAssignmentGetResultsInner> getSqlRoleAssignmentAsync(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleAssignmentGetResultsInner getSqlRoleAssignment(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SqlRoleAssignmentGetResultsInner> getSqlRoleAssignmentWithResponse(
        String roleAssignmentId, String resourceGroupName, String accountName, Context context);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleAssignmentWithResponseAsync(
        String roleAssignmentId,
        String resourceGroupName,
        String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignmentAsync(
            String roleAssignmentId,
            String resourceGroupName,
            String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignment(
            String roleAssignmentId,
            String resourceGroupName,
            String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignment(
            String roleAssignmentId,
            String resourceGroupName,
            String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters,
            Context context);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SqlRoleAssignmentGetResultsInner> createUpdateSqlRoleAssignmentAsync(
        String roleAssignmentId,
        String resourceGroupName,
        String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleAssignmentGetResultsInner createUpdateSqlRoleAssignment(
        String roleAssignmentId,
        String resourceGroupName,
        String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters);

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SqlRoleAssignmentGetResultsInner createUpdateSqlRoleAssignment(
        String roleAssignmentId,
        String resourceGroupName,
        String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters,
        Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleAssignmentWithResponseAsync(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleAssignmentAsync(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleAssignment(
        String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleAssignment(
        String roleAssignmentId, String resourceGroupName, String accountName, Context context);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSqlRoleAssignmentAsync(String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlRoleAssignment(String roleAssignmentId, String resourceGroupName, String accountName);

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     *
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSqlRoleAssignment(
        String roleAssignmentId, String resourceGroupName, String accountName, Context context);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignmentsAsync(
        String resourceGroupName, String accountName);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignments(
        String resourceGroupName, String accountName);

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignments(
        String resourceGroupName, String accountName, Context context);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String containerName,
            ContinuousBackupRestoreLocation location);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner> beginRetrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner> beginRetrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location,
        Context context);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupInformationInner retrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location);

    /**
     * Retrieves continuous backup information for a container resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupInformationInner retrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String containerName,
        ContinuousBackupRestoreLocation location,
        Context context);
}
