// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountConnectionString;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The connection strings for the given database account. */
@Fluent
public final class DatabaseAccountListConnectionStringsResultInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DatabaseAccountListConnectionStringsResultInner.class);

    /*
     * An array that contains the connection strings for the Cosmos DB account.
     */
    @JsonProperty(value = "connectionStrings")
    private List<DatabaseAccountConnectionString> connectionStrings;

    /**
     * Get the connectionStrings property: An array that contains the connection strings for the Cosmos DB account.
     *
     * @return the connectionStrings value.
     */
    public List<DatabaseAccountConnectionString> connectionStrings() {
        return this.connectionStrings;
    }

    /**
     * Set the connectionStrings property: An array that contains the connection strings for the Cosmos DB account.
     *
     * @param connectionStrings the connectionStrings value to set.
     * @return the DatabaseAccountListConnectionStringsResultInner object itself.
     */
    public DatabaseAccountListConnectionStringsResultInner withConnectionStrings(
        List<DatabaseAccountConnectionString> connectionStrings) {
        this.connectionStrings = connectionStrings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionStrings() != null) {
            connectionStrings().forEach(e -> e.validate());
        }
    }
}
