// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** A Azure Cosmos DB restorable database account. */
@JsonFlatten
@Fluent
public class RestorableDatabaseAccountGetResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RestorableDatabaseAccountGetResultInner.class);

    /*
     * The unique resource identifier of the ARM resource.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the ARM resource.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The type of Azure resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The location of the resource group to which the resource belongs.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The name of the global database account
     */
    @JsonProperty(value = "properties.accountName")
    private String accountName;

    /*
     * The creation time of the restorable database account (ISO-8601 format).
     */
    @JsonProperty(value = "properties.creationTime")
    private OffsetDateTime creationTime;

    /*
     * The time at which the restorable database account has been deleted
     * (ISO-8601 format).
     */
    @JsonProperty(value = "properties.deletionTime")
    private OffsetDateTime deletionTime;

    /*
     * The API type of the restorable database account.
     */
    @JsonProperty(value = "properties.apiType", access = JsonProperty.Access.WRITE_ONLY)
    private ApiType apiType;

    /*
     * List of regions where the of the database account can be restored from.
     */
    @JsonProperty(value = "properties.restorableLocations", access = JsonProperty.Access.WRITE_ONLY)
    private List<RestorableLocationResource> restorableLocations;

    /**
     * Get the id property: The unique resource identifier of the ARM resource.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: The location of the resource group to which the resource belongs.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the resource group to which the resource belongs.
     *
     * @param location the location value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the accountName property: The name of the global database account.
     *
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The name of the global database account.
     *
     * @param accountName the accountName value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     *
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     *
     * @param creationTime the creationTime value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     *
     * @return the deletionTime value.
     */
    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    /**
     * Set the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     *
     * @param deletionTime the deletionTime value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withDeletionTime(OffsetDateTime deletionTime) {
        this.deletionTime = deletionTime;
        return this;
    }

    /**
     * Get the apiType property: The API type of the restorable database account.
     *
     * @return the apiType value.
     */
    public ApiType apiType() {
        return this.apiType;
    }

    /**
     * Get the restorableLocations property: List of regions where the of the database account can be restored from.
     *
     * @return the restorableLocations value.
     */
    public List<RestorableLocationResource> restorableLocations() {
        return this.restorableLocations;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (restorableLocations() != null) {
            restorableLocations().forEach(e -> e.validate());
        }
    }
}
