// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.Permission;
import com.azure.resourcemanager.cosmos.models.RoleDefinitionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An Azure Cosmos DB SQL Role Definition. */
@JsonFlatten
@Fluent
public class SqlRoleDefinitionGetResultsInner extends ArmProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlRoleDefinitionGetResultsInner.class);

    /*
     * A user-friendly name for the Role Definition. Must be unique for the
     * database account.
     */
    @JsonProperty(value = "properties.roleName")
    private String roleName;

    /*
     * Indicates whether the Role Definition was built-in or user created.
     */
    @JsonProperty(value = "properties.type")
    private RoleDefinitionType typePropertiesType;

    /*
     * A set of fully qualified Scopes at or below which Role Assignments may
     * be created using this Role Definition. This will allow application of
     * this Role Definition on the entire database account or any underlying
     * Database / Collection. Must have at least one element. Scopes higher
     * than Database account are not enforceable as assignable Scopes. Note
     * that resources referenced in assignable Scopes need not exist.
     */
    @JsonProperty(value = "properties.assignableScopes")
    private List<String> assignableScopes;

    /*
     * The set of operations allowed through this Role Definition.
     */
    @JsonProperty(value = "properties.permissions")
    private List<Permission> permissions;

    /**
     * Get the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     *
     * @return the roleName value.
     */
    public String roleName() {
        return this.roleName;
    }

    /**
     * Set the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     *
     * @param roleName the roleName value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    /**
     * Get the typePropertiesType property: Indicates whether the Role Definition was built-in or user created.
     *
     * @return the typePropertiesType value.
     */
    public RoleDefinitionType typePropertiesType() {
        return this.typePropertiesType;
    }

    /**
     * Set the typePropertiesType property: Indicates whether the Role Definition was built-in or user created.
     *
     * @param typePropertiesType the typePropertiesType value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withTypePropertiesType(RoleDefinitionType typePropertiesType) {
        this.typePropertiesType = typePropertiesType;
        return this;
    }

    /**
     * Get the assignableScopes property: A set of fully qualified Scopes at or below which Role Assignments may be
     * created using this Role Definition. This will allow application of this Role Definition on the entire database
     * account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database
     * account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not
     * exist.
     *
     * @return the assignableScopes value.
     */
    public List<String> assignableScopes() {
        return this.assignableScopes;
    }

    /**
     * Set the assignableScopes property: A set of fully qualified Scopes at or below which Role Assignments may be
     * created using this Role Definition. This will allow application of this Role Definition on the entire database
     * account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database
     * account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not
     * exist.
     *
     * @param assignableScopes the assignableScopes value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withAssignableScopes(List<String> assignableScopes) {
        this.assignableScopes = assignableScopes;
        return this;
    }

    /**
     * Get the permissions property: The set of operations allowed through this Role Definition.
     *
     * @return the permissions value.
     */
    public List<Permission> permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: The set of operations allowed through this Role Definition.
     *
     * @param permissions the permissions value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (permissions() != null) {
            permissions().forEach(e -> e.validate());
        }
    }
}
