// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Cosmos DB resource auto-upgrade policy. */
@Fluent
public final class AutoUpgradePolicyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AutoUpgradePolicyResource.class);

    /*
     * Represents throughput policy which service must adhere to for
     * auto-upgrade
     */
    @JsonProperty(value = "throughputPolicy")
    private ThroughputPolicyResource throughputPolicy;

    /**
     * Get the throughputPolicy property: Represents throughput policy which service must adhere to for auto-upgrade.
     *
     * @return the throughputPolicy value.
     */
    public ThroughputPolicyResource throughputPolicy() {
        return this.throughputPolicy;
    }

    /**
     * Set the throughputPolicy property: Represents throughput policy which service must adhere to for auto-upgrade.
     *
     * @param throughputPolicy the throughputPolicy value to set.
     * @return the AutoUpgradePolicyResource object itself.
     */
    public AutoUpgradePolicyResource withThroughputPolicy(ThroughputPolicyResource throughputPolicy) {
        this.throughputPolicy = throughputPolicy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (throughputPolicy() != null) {
            throughputPolicy().validate();
        }
    }
}
