// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The set of data plane operations permitted through this Role Definition. */
@Fluent
public final class Permission {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Permission.class);

    /*
     * An array of data actions that are allowed.
     */
    @JsonProperty(value = "dataActions")
    private List<String> dataActions;

    /*
     * An array of data actions that are denied.
     */
    @JsonProperty(value = "notDataActions")
    private List<String> notDataActions;

    /**
     * Get the dataActions property: An array of data actions that are allowed.
     *
     * @return the dataActions value.
     */
    public List<String> dataActions() {
        return this.dataActions;
    }

    /**
     * Set the dataActions property: An array of data actions that are allowed.
     *
     * @param dataActions the dataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withDataActions(List<String> dataActions) {
        this.dataActions = dataActions;
        return this;
    }

    /**
     * Get the notDataActions property: An array of data actions that are denied.
     *
     * @return the notDataActions value.
     */
    public List<String> notDataActions() {
        return this.notDataActions;
    }

    /**
     * Set the notDataActions property: An array of data actions that are denied.
     *
     * @param notDataActions the notDataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withNotDataActions(List<String> notDataActions) {
        this.notDataActions = notDataActions;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
