// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Parameters to update Cosmos DB resource throughput. */
@JsonFlatten
@Fluent
public class ThroughputSettingsUpdateParameters extends ArmResourceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ThroughputSettingsUpdateParameters.class);

    /*
     * The standard JSON format of a resource throughput
     */
    @JsonProperty(value = "properties.resource", required = true)
    private ThroughputSettingsResource resource;

    /**
     * Get the resource property: The standard JSON format of a resource throughput.
     *
     * @return the resource value.
     */
    public ThroughputSettingsResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The standard JSON format of a resource throughput.
     *
     * @param resource the resource value to set.
     * @return the ThroughputSettingsUpdateParameters object itself.
     */
    public ThroughputSettingsUpdateParameters withResource(ThroughputSettingsResource resource) {
        this.resource = resource;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ThroughputSettingsUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ThroughputSettingsUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (resource() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property resource in model ThroughputSettingsUpdateParameters"));
        } else {
            resource().validate();
        }
    }
}
