/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlContainerResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class SqlContainerCreateUpdateParameters
extends ArmResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SqlContainerCreateUpdateParameters.class);
    @JsonProperty(value="properties.resource", required=true)
    private SqlContainerResource resource;
    @JsonProperty(value="properties.options")
    private CreateUpdateOptions options;

    public SqlContainerResource resource() {
        return this.resource;
    }

    public SqlContainerCreateUpdateParameters withResource(SqlContainerResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public SqlContainerCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public SqlContainerCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public SqlContainerCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.resource() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resource in model SqlContainerCreateUpdateParameters"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }
}

