// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.CostManagementClient;
import com.azure.resourcemanager.costmanagement.implementation.AlertsImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitRecommendationsImpl;
import com.azure.resourcemanager.costmanagement.implementation.BenefitUtilizationSummariesImpl;
import com.azure.resourcemanager.costmanagement.implementation.CostManagementClientBuilder;
import com.azure.resourcemanager.costmanagement.implementation.DimensionsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ExportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ForecastsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateCostDetailsReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationResultsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportOperationStatusImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateDetailedCostReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.GenerateReservationDetailsReportsImpl;
import com.azure.resourcemanager.costmanagement.implementation.OperationsImpl;
import com.azure.resourcemanager.costmanagement.implementation.PriceSheetsImpl;
import com.azure.resourcemanager.costmanagement.implementation.QueriesImpl;
import com.azure.resourcemanager.costmanagement.implementation.ScheduledActionsImpl;
import com.azure.resourcemanager.costmanagement.implementation.ViewsImpl;
import com.azure.resourcemanager.costmanagement.models.Alerts;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendations;
import com.azure.resourcemanager.costmanagement.models.BenefitUtilizationSummaries;
import com.azure.resourcemanager.costmanagement.models.Dimensions;
import com.azure.resourcemanager.costmanagement.models.Exports;
import com.azure.resourcemanager.costmanagement.models.Forecasts;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReports;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationResults;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReportOperationStatus;
import com.azure.resourcemanager.costmanagement.models.GenerateDetailedCostReports;
import com.azure.resourcemanager.costmanagement.models.GenerateReservationDetailsReports;
import com.azure.resourcemanager.costmanagement.models.Operations;
import com.azure.resourcemanager.costmanagement.models.PriceSheets;
import com.azure.resourcemanager.costmanagement.models.Queries;
import com.azure.resourcemanager.costmanagement.models.ScheduledActions;
import com.azure.resourcemanager.costmanagement.models.Views;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Entry point to CostManagementManager. CostManagement management client provides access to CostManagement resources
 * for Azure Enterprise Subscriptions.
 */
public final class CostManagementManager {
    private Operations operations;

    private Views views;

    private Alerts alerts;

    private Forecasts forecasts;

    private Dimensions dimensions;

    private Queries queries;

    private GenerateReservationDetailsReports generateReservationDetailsReports;

    private Exports exports;

    private GenerateCostDetailsReports generateCostDetailsReports;

    private GenerateDetailedCostReports generateDetailedCostReports;

    private GenerateDetailedCostReportOperationResults generateDetailedCostReportOperationResults;

    private GenerateDetailedCostReportOperationStatus generateDetailedCostReportOperationStatus;

    private PriceSheets priceSheets;

    private ScheduledActions scheduledActions;

    private BenefitRecommendations benefitRecommendations;

    private BenefitUtilizationSummaries benefitUtilizationSummaries;

    private final CostManagementClient clientObject;

    private CostManagementManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject =
            new CostManagementClientBuilder()
                .pipeline(httpPipeline)
                .endpoint(profile.getEnvironment().getResourceManagerEndpoint())
                .defaultPollInterval(defaultPollInterval)
                .buildClient();
    }

    /**
     * Creates an instance of CostManagement service API entry point.
     *
     * @param credential the credential to use.
     * @param profile the Azure profile for client.
     * @return the CostManagement service API instance.
     */
    public static CostManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return configure().authenticate(credential, profile);
    }

    /**
     * Creates an instance of CostManagement service API entry point.
     *
     * @param httpPipeline the {@link HttpPipeline} configured with Azure authentication credential.
     * @param profile the Azure profile for client.
     * @return the CostManagement service API instance.
     */
    public static CostManagementManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new CostManagementManager(httpPipeline, profile, null);
    }

    /**
     * Gets a Configurable instance that can be used to create CostManagementManager with optional configuration.
     *
     * @return the Configurable instance allowing configurations.
     */
    public static Configurable configure() {
        return new CostManagementManager.Configurable();
    }

    /** The Configurable allowing configurations to be set. */
    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);

        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<>();
        private final List<String> scopes = new ArrayList<>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        /**
         * Sets the http client.
         *
         * @param httpClient the HTTP client.
         * @return the configurable object itself.
         */
        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        /**
         * Sets the logging options to the HTTP pipeline.
         *
         * @param httpLogOptions the HTTP log options.
         * @return the configurable object itself.
         */
        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        /**
         * Adds the pipeline policy to the HTTP pipeline.
         *
         * @param policy the HTTP pipeline policy.
         * @return the configurable object itself.
         */
        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        /**
         * Adds the scope to permission sets.
         *
         * @param scope the scope.
         * @return the configurable object itself.
         */
        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        /**
         * Sets the retry policy to the HTTP pipeline.
         *
         * @param retryPolicy the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        /**
         * Sets the retry options for the HTTP pipeline retry policy.
         *
         * <p>This setting has no effect, if retry policy is set via {@link #withRetryPolicy(RetryPolicy)}.
         *
         * @param retryOptions the retry options for the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        /**
         * Sets the default poll interval, used when service does not provide "Retry-After" header.
         *
         * @param defaultPollInterval the default poll interval.
         * @return the configurable object itself.
         */
        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval =
                Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER
                    .logExceptionAsError(new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        /**
         * Creates an instance of CostManagement service API entry point.
         *
         * @param credential the credential to use.
         * @param profile the Azure profile for client.
         * @return the CostManagement service API instance.
         */
        public CostManagementManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");

            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder
                .append("azsdk-java")
                .append("-")
                .append("com.azure.resourcemanager.costmanagement")
                .append("/")
                .append("1.0.0-beta.6");
            if (!Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false)) {
                userAgentBuilder
                    .append(" (")
                    .append(Configuration.getGlobalConfiguration().get("java.version"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.name"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.version"))
                    .append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }

            if (scopes.isEmpty()) {
                scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (retryPolicy == null) {
                if (retryOptions != null) {
                    retryPolicy = new RetryPolicy(retryOptions);
                } else {
                    retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
                }
            }
            List<HttpPipelinePolicy> policies = new ArrayList<>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies
                .addAll(
                    this
                        .policies
                        .stream()
                        .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL)
                        .collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, scopes.toArray(new String[0])));
            policies
                .addAll(
                    this
                        .policies
                        .stream()
                        .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY)
                        .collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(httpLogOptions));
            HttpPipeline httpPipeline =
                new HttpPipelineBuilder()
                    .httpClient(httpClient)
                    .policies(policies.toArray(new HttpPipelinePolicy[0]))
                    .build();
            return new CostManagementManager(httpPipeline, profile, defaultPollInterval);
        }
    }

    /**
     * Gets the resource collection API of Operations.
     *
     * @return Resource collection API of Operations.
     */
    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(clientObject.getOperations(), this);
        }
        return operations;
    }

    /**
     * Gets the resource collection API of Views. It manages View.
     *
     * @return Resource collection API of Views.
     */
    public Views views() {
        if (this.views == null) {
            this.views = new ViewsImpl(clientObject.getViews(), this);
        }
        return views;
    }

    /**
     * Gets the resource collection API of Alerts.
     *
     * @return Resource collection API of Alerts.
     */
    public Alerts alerts() {
        if (this.alerts == null) {
            this.alerts = new AlertsImpl(clientObject.getAlerts(), this);
        }
        return alerts;
    }

    /**
     * Gets the resource collection API of Forecasts.
     *
     * @return Resource collection API of Forecasts.
     */
    public Forecasts forecasts() {
        if (this.forecasts == null) {
            this.forecasts = new ForecastsImpl(clientObject.getForecasts(), this);
        }
        return forecasts;
    }

    /**
     * Gets the resource collection API of Dimensions.
     *
     * @return Resource collection API of Dimensions.
     */
    public Dimensions dimensions() {
        if (this.dimensions == null) {
            this.dimensions = new DimensionsImpl(clientObject.getDimensions(), this);
        }
        return dimensions;
    }

    /**
     * Gets the resource collection API of Queries.
     *
     * @return Resource collection API of Queries.
     */
    public Queries queries() {
        if (this.queries == null) {
            this.queries = new QueriesImpl(clientObject.getQueries(), this);
        }
        return queries;
    }

    /**
     * Gets the resource collection API of GenerateReservationDetailsReports.
     *
     * @return Resource collection API of GenerateReservationDetailsReports.
     */
    public GenerateReservationDetailsReports generateReservationDetailsReports() {
        if (this.generateReservationDetailsReports == null) {
            this.generateReservationDetailsReports =
                new GenerateReservationDetailsReportsImpl(clientObject.getGenerateReservationDetailsReports(), this);
        }
        return generateReservationDetailsReports;
    }

    /**
     * Gets the resource collection API of Exports. It manages Export.
     *
     * @return Resource collection API of Exports.
     */
    public Exports exports() {
        if (this.exports == null) {
            this.exports = new ExportsImpl(clientObject.getExports(), this);
        }
        return exports;
    }

    /**
     * Gets the resource collection API of GenerateCostDetailsReports.
     *
     * @return Resource collection API of GenerateCostDetailsReports.
     */
    public GenerateCostDetailsReports generateCostDetailsReports() {
        if (this.generateCostDetailsReports == null) {
            this.generateCostDetailsReports =
                new GenerateCostDetailsReportsImpl(clientObject.getGenerateCostDetailsReports(), this);
        }
        return generateCostDetailsReports;
    }

    /**
     * Gets the resource collection API of GenerateDetailedCostReports.
     *
     * @return Resource collection API of GenerateDetailedCostReports.
     */
    public GenerateDetailedCostReports generateDetailedCostReports() {
        if (this.generateDetailedCostReports == null) {
            this.generateDetailedCostReports =
                new GenerateDetailedCostReportsImpl(clientObject.getGenerateDetailedCostReports(), this);
        }
        return generateDetailedCostReports;
    }

    /**
     * Gets the resource collection API of GenerateDetailedCostReportOperationResults.
     *
     * @return Resource collection API of GenerateDetailedCostReportOperationResults.
     */
    public GenerateDetailedCostReportOperationResults generateDetailedCostReportOperationResults() {
        if (this.generateDetailedCostReportOperationResults == null) {
            this.generateDetailedCostReportOperationResults =
                new GenerateDetailedCostReportOperationResultsImpl(
                    clientObject.getGenerateDetailedCostReportOperationResults(), this);
        }
        return generateDetailedCostReportOperationResults;
    }

    /**
     * Gets the resource collection API of GenerateDetailedCostReportOperationStatus.
     *
     * @return Resource collection API of GenerateDetailedCostReportOperationStatus.
     */
    public GenerateDetailedCostReportOperationStatus generateDetailedCostReportOperationStatus() {
        if (this.generateDetailedCostReportOperationStatus == null) {
            this.generateDetailedCostReportOperationStatus =
                new GenerateDetailedCostReportOperationStatusImpl(
                    clientObject.getGenerateDetailedCostReportOperationStatus(), this);
        }
        return generateDetailedCostReportOperationStatus;
    }

    /**
     * Gets the resource collection API of PriceSheets.
     *
     * @return Resource collection API of PriceSheets.
     */
    public PriceSheets priceSheets() {
        if (this.priceSheets == null) {
            this.priceSheets = new PriceSheetsImpl(clientObject.getPriceSheets(), this);
        }
        return priceSheets;
    }

    /**
     * Gets the resource collection API of ScheduledActions. It manages ScheduledAction.
     *
     * @return Resource collection API of ScheduledActions.
     */
    public ScheduledActions scheduledActions() {
        if (this.scheduledActions == null) {
            this.scheduledActions = new ScheduledActionsImpl(clientObject.getScheduledActions(), this);
        }
        return scheduledActions;
    }

    /**
     * Gets the resource collection API of BenefitRecommendations.
     *
     * @return Resource collection API of BenefitRecommendations.
     */
    public BenefitRecommendations benefitRecommendations() {
        if (this.benefitRecommendations == null) {
            this.benefitRecommendations =
                new BenefitRecommendationsImpl(clientObject.getBenefitRecommendations(), this);
        }
        return benefitRecommendations;
    }

    /**
     * Gets the resource collection API of BenefitUtilizationSummaries.
     *
     * @return Resource collection API of BenefitUtilizationSummaries.
     */
    public BenefitUtilizationSummaries benefitUtilizationSummaries() {
        if (this.benefitUtilizationSummaries == null) {
            this.benefitUtilizationSummaries =
                new BenefitUtilizationSummariesImpl(clientObject.getBenefitUtilizationSummaries(), this);
        }
        return benefitUtilizationSummaries;
    }

    /**
     * @return Wrapped service client CostManagementClient providing direct access to the underlying auto-generated API
     *     implementation, based on Azure REST API.
     */
    public CostManagementClient serviceClient() {
        return this.clientObject;
    }
}
