// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;

/** An instance of this class provides access to all the operations defined in GenerateCostDetailsReportsClient. */
public interface GenerateCostDetailsReportsClient {
    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperation(
        String scope, GenerateCostDetailsReportRequestDefinition parameters);

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginCreateOperation(
        String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context);

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CostDetailsOperationResultsInner createOperation(
        String scope, GenerateCostDetailsReportRequestDefinition parameters);

    /**
     * This API is the replacement for all previously release Usage Details APIs. Request to generate a cost details
     * report for the provided date range, billing period (Only enterprise customers) or Invoice Id asynchronously at a
     * certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After' header.
     * The 'Location' header will provide the endpoint to poll to get the result of the report generation. The
     * 'Retry-After' provides the duration to wait before polling for the generated report. A call to poll the report
     * operation will provide a 202 response with a 'Location' header if the operation is still in progress. Once the
     * report generation operation completes, the polling endpoint will provide a 200 response along with details on the
     * report blob(s) that are available for download. The details on the file(s) available for download will be
     * available in the polling response body. To Understand cost details (formerly known as usage details) fields found
     * in files ,see https://learn.microsoft.com/azure/cost-management-billing/automate/understand-usage-details-fields.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param parameters Parameters supplied to the Create cost details operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the long running operation for cost details Api.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CostDetailsOperationResultsInner createOperation(
        String scope, GenerateCostDetailsReportRequestDefinition parameters, Context context);

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResults(
        String scope, String operationId);

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<CostDetailsOperationResultsInner>, CostDetailsOperationResultsInner> beginGetOperationResults(
        String scope, String operationId, Context context);

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CostDetailsOperationResultsInner getOperationResults(String scope, String operationId);

    /**
     * Get the result of the specified operation. This link is provided in the CostDetails creation request response
     * Location header.
     *
     * @param scope The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For
     *     details, see https://aka.ms/costmgmt/scopes.
     * @param operationId The target operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of the specified operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CostDetailsOperationResultsInner getOperationResults(String scope, String operationId, Context context);
}
