// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDefinition;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDetails;
import com.azure.resourcemanager.costmanagement.models.AlertSource;
import com.azure.resourcemanager.costmanagement.models.AlertStatus;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An individual alert. */
@Fluent
public final class AlertInner extends CostManagementProxyResource {
    /*
     * Alert properties.
     */
    @JsonProperty(value = "properties")
    private AlertProperties innerProperties;

    /** Creates an instance of AlertInner class. */
    public AlertInner() {
    }

    /**
     * Get the innerProperties property: Alert properties.
     *
     * @return the innerProperties value.
     */
    private AlertProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public AlertInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /**
     * Get the definition property: defines the type of alert.
     *
     * @return the definition value.
     */
    public AlertPropertiesDefinition definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    /**
     * Set the definition property: defines the type of alert.
     *
     * @param definition the definition value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withDefinition(AlertPropertiesDefinition definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    /**
     * Get the description property: Alert description.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Alert description.
     *
     * @param description the description value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the source property: Source of alert.
     *
     * @return the source value.
     */
    public AlertSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Source of alert.
     *
     * @param source the source value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withSource(AlertSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the details property: Alert details.
     *
     * @return the details value.
     */
    public AlertPropertiesDetails details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    /**
     * Set the details property: Alert details.
     *
     * @param details the details value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withDetails(AlertPropertiesDetails details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    /**
     * Get the costEntityId property: related budget.
     *
     * @return the costEntityId value.
     */
    public String costEntityId() {
        return this.innerProperties() == null ? null : this.innerProperties().costEntityId();
    }

    /**
     * Set the costEntityId property: related budget.
     *
     * @param costEntityId the costEntityId value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withCostEntityId(String costEntityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCostEntityId(costEntityId);
        return this;
    }

    /**
     * Get the status property: alert status.
     *
     * @return the status value.
     */
    public AlertStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: alert status.
     *
     * @param status the status value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withStatus(AlertStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the creationTime property: dateTime in which alert was created.
     *
     * @return the creationTime value.
     */
    public String creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    /**
     * Set the creationTime property: dateTime in which alert was created.
     *
     * @param creationTime the creationTime value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withCreationTime(String creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    /**
     * Get the closeTime property: dateTime in which alert was closed.
     *
     * @return the closeTime value.
     */
    public String closeTime() {
        return this.innerProperties() == null ? null : this.innerProperties().closeTime();
    }

    /**
     * Set the closeTime property: dateTime in which alert was closed.
     *
     * @param closeTime the closeTime value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withCloseTime(String closeTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withCloseTime(closeTime);
        return this;
    }

    /**
     * Get the modificationTime property: dateTime in which alert was last modified.
     *
     * @return the modificationTime value.
     */
    public String modificationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().modificationTime();
    }

    /**
     * Set the modificationTime property: dateTime in which alert was last modified.
     *
     * @param modificationTime the modificationTime value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withModificationTime(String modificationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withModificationTime(modificationTime);
        return this;
    }

    /**
     * Get the statusModificationUsername property: User who last modified the alert.
     *
     * @return the statusModificationUsername value.
     */
    public String statusModificationUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().statusModificationUsername();
    }

    /**
     * Set the statusModificationUsername property: User who last modified the alert.
     *
     * @param statusModificationUsername the statusModificationUsername value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withStatusModificationUsername(String statusModificationUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatusModificationUsername(statusModificationUsername);
        return this;
    }

    /**
     * Get the statusModificationTime property: dateTime in which the alert status was last modified.
     *
     * @return the statusModificationTime value.
     */
    public String statusModificationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().statusModificationTime();
    }

    /**
     * Set the statusModificationTime property: dateTime in which the alert status was last modified.
     *
     * @param statusModificationTime the statusModificationTime value to set.
     * @return the AlertInner object itself.
     */
    public AlertInner withStatusModificationTime(String statusModificationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AlertProperties();
        }
        this.innerProperties().withStatusModificationTime(statusModificationTime);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
