// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of listing the run history of an export. */
@Immutable
public final class ExportExecutionListResultInner {
    /*
     * A list of export runs.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<ExportRunInner> value;

    /** Creates an instance of ExportExecutionListResultInner class. */
    public ExportExecutionListResultInner() {
    }

    /**
     * Get the value property: A list of export runs.
     *
     * @return the value value.
     */
    public List<ExportRunInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
