// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.CostManagementProxyResource;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportSchedule;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An export resource. */
@Fluent
public final class ExportInner extends CostManagementProxyResource {
    /*
     * The properties of the export.
     */
    @JsonProperty(value = "properties")
    private ExportProperties innerProperties;

    /** Creates an instance of ExportInner class. */
    public ExportInner() {
    }

    /**
     * Get the innerProperties property: The properties of the export.
     *
     * @return the innerProperties value.
     */
    private ExportProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ExportInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /**
     * Get the schedule property: Has schedule information for the export.
     *
     * @return the schedule value.
     */
    public ExportSchedule schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    /**
     * Set the schedule property: Has schedule information for the export.
     *
     * @param schedule the schedule value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withSchedule(ExportSchedule schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    /**
     * Get the format property: The format of the export being delivered. Currently only 'Csv' is supported.
     *
     * @return the format value.
     */
    public FormatType format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    /**
     * Set the format property: The format of the export being delivered. Currently only 'Csv' is supported.
     *
     * @param format the format value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withFormat(FormatType format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    /**
     * Get the deliveryInfo property: Has delivery information for the export.
     *
     * @return the deliveryInfo value.
     */
    public ExportDeliveryInfo deliveryInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryInfo();
    }

    /**
     * Set the deliveryInfo property: Has delivery information for the export.
     *
     * @param deliveryInfo the deliveryInfo value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withDeliveryInfo(ExportDeliveryInfo deliveryInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withDeliveryInfo(deliveryInfo);
        return this;
    }

    /**
     * Get the definition property: Has the definition for the export.
     *
     * @return the definition value.
     */
    public ExportDefinition definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    /**
     * Set the definition property: Has the definition for the export.
     *
     * @param definition the definition value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withDefinition(ExportDefinition definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    /**
     * Get the runHistory property: If requested, has the most recent run history for the export.
     *
     * @return the runHistory value.
     */
    public ExportExecutionListResultInner runHistory() {
        return this.innerProperties() == null ? null : this.innerProperties().runHistory();
    }

    /**
     * Set the runHistory property: If requested, has the most recent run history for the export.
     *
     * @param runHistory the runHistory value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withRunHistory(ExportExecutionListResultInner runHistory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withRunHistory(runHistory);
        return this;
    }

    /**
     * Get the partitionData property: If set to true, exported data will be partitioned by size and placed in a blob
     * directory together with a manifest file. Note: this option is currently available only for Microsoft Customer
     * Agreement commerce scopes.
     *
     * @return the partitionData value.
     */
    public Boolean partitionData() {
        return this.innerProperties() == null ? null : this.innerProperties().partitionData();
    }

    /**
     * Set the partitionData property: If set to true, exported data will be partitioned by size and placed in a blob
     * directory together with a manifest file. Note: this option is currently available only for Microsoft Customer
     * Agreement commerce scopes.
     *
     * @param partitionData the partitionData value to set.
     * @return the ExportInner object itself.
     */
    public ExportInner withPartitionData(Boolean partitionData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExportProperties();
        }
        this.innerProperties().withPartitionData(partitionData);
        return this;
    }

    /**
     * Get the nextRunTimeEstimate property: If the export has an active schedule, provides an estimate of the next run
     * time.
     *
     * @return the nextRunTimeEstimate value.
     */
    public OffsetDateTime nextRunTimeEstimate() {
        return this.innerProperties() == null ? null : this.innerProperties().nextRunTimeEstimate();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
